package com.digiwin.athena.apimgmt.services;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.enums.ApiAttributeEnum;
import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.model.ProductApiDataName;
import com.digiwin.athena.apimgmt.model.StandardApiDataName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class ApiDataNameService {

    public static List<String> dataNameList = new ArrayList<>();

    ObjectMapper mapper = new ObjectMapper();

    public void setReaponseMessageSpec(ObjectNode pResponseNode, List<StandardApiDataName> pStandardApiDataNameList, String pMessageSpec, int pMsgType, String pLocale) {
        ArrayNode tSpecAryNode = mapper.createArrayNode();
        pResponseNode.set(pMessageSpec, tSpecAryNode);
        for (StandardApiDataName standardApiDataName : pStandardApiDataNameList) {
            if (standardApiDataName.getMsgType() == pMsgType) {
                ObjectNode tMessageSpecNode = mapper.createObjectNode();
                String tColumnType = standardApiDataName.getColumnType();
                long tId = standardApiDataName.getId();
                long tParentId;
                String tIsDataKey = standardApiDataName.getIsDatakey() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
                String tIsRequired = standardApiDataName.getIsRequired() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
                String tIsArray = standardApiDataName.getIsArray() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
                String tCanSort = standardApiDataName.getCanSort() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
                String tCanFilter = standardApiDataName.getCanFilter() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
                String tIsBusinessKey = standardApiDataName.getIsBusinesskey() ? ApimgmtConstant.YES : ApimgmtConstant.NO;
                List<ProductApiDataName> productApiDataNames = standardApiDataName.getProductApiDataNames();
                ObjectNode productPrecision = mapper.createObjectNode();
                if (CollUtil.isNotEmpty(productApiDataNames)) {
                    productApiDataNames.forEach(x -> {
                        String precision = null;
                        if (null != x.getLength()) {
                            precision = String.valueOf(x.getLength());
                        }
                        if (null != x.getPrecision()) {
                            precision = precision + "," + x.getPrecision();
                        }
                        productPrecision.put(x.getProductName(), precision);
                    });
                }
                String tDataType = standardApiDataName.getDataType() == null ? "" : standardApiDataName.getDataType();
                String tDataDescription;
                String tDataRemark;
                String tValue = standardApiDataName.getValue() == null ? "" : standardApiDataName.getValue();
                String tListEnum;
                String tHistory = standardApiDataName.getUpdateHistory() == null ? "" : standardApiDataName.getUpdateHistory();
                switch (pLocale) {
                    case ApimgmtConstant.ZH_CN:
                        tDataDescription = standardApiDataName.getDescriptionZhCn();
                        tDataRemark = standardApiDataName.getRemarkZhCn() == null ? "" : standardApiDataName.getRemarkZhCn();
                        tListEnum = standardApiDataName.getListEnumZhCn() == null ? "" : standardApiDataName.getListEnumZhCn();
                        break;
                    case ApimgmtConstant.ZH_TW:
                        tDataDescription = standardApiDataName.getDescriptionZhTw();
                        tDataRemark = standardApiDataName.getRemarkZhTw() == null ? "" : standardApiDataName.getRemarkZhTw();
                        tListEnum = standardApiDataName.getListEnumZhTw() == null ? "" : standardApiDataName.getListEnumZhTw();
                        break;
                    case ApimgmtConstant.EN_US:
                    default:
                        tDataDescription = standardApiDataName.getDescriptionEnUs();
                        tDataRemark = standardApiDataName.getRemarkEnUs() == null ? "" : standardApiDataName.getRemarkEnUs();
                        tListEnum = standardApiDataName.getListEnumEn() == null ? "" : standardApiDataName.getListEnumEn();
                        break;
                }
                ObjectNode tDataNameDescriptionMultilingualNode = mapper.createObjectNode();
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getDescriptionZhTw());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getDescriptionZhCn());
                tDataNameDescriptionMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getDescriptionEnUs());
                ObjectNode tDataRemarkMultilingualNode = mapper.createObjectNode();
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getRemarkZhTw() == null ? "" : standardApiDataName.getRemarkZhTw());
                tDataRemarkMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getRemarkZhCn() == null ? "" : standardApiDataName.getRemarkZhCn());
                tDataRemarkMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getRemarkEnUs() == null ? "" : standardApiDataName.getRemarkEnUs());
                ObjectNode tListEnumMultilingualNode = mapper.createObjectNode();
                tListEnumMultilingualNode.put(LocaleEnum.ZH_TW.getType(), standardApiDataName.getListEnumZhTw() == null ? "" : standardApiDataName.getListEnumZhTw());
                tListEnumMultilingualNode.put(LocaleEnum.ZH_CN.getType(), standardApiDataName.getListEnumZhCn() == null ? "" : standardApiDataName.getListEnumZhCn());
                tListEnumMultilingualNode.put(LocaleEnum.EN_US.getType(), standardApiDataName.getListEnumEn() == null ? "" : standardApiDataName.getListEnumEn());
                String tDataName = standardApiDataName.getStandardDataName();
                if (standardApiDataName.getParentId() != null) {
                    tParentId = standardApiDataName.getParentId();
                    tMessageSpecNode.put(ApiAttributeEnum.parent.toString(), tParentId);
                }
                tMessageSpecNode.put(ApiAttributeEnum.columnType.toString(), tColumnType);
                tMessageSpecNode.put(ApiAttributeEnum.id.toString(), tId);
                tMessageSpecNode.put(ApiAttributeEnum.dataName.toString(), tDataName);
                tMessageSpecNode.set(ApiAttributeEnum.dataDescriptionMultilingual.toString(), tDataNameDescriptionMultilingualNode);
                tMessageSpecNode.set(ApiAttributeEnum.dataNameRemarkMultilingual.toString(), tDataRemarkMultilingualNode);
                tMessageSpecNode.set(ApiAttributeEnum.listEnumMultilingual.toString(), tListEnumMultilingualNode);
                tMessageSpecNode.put(ApiAttributeEnum.dataDescription.toString(), tDataDescription);
                tMessageSpecNode.put(ApiAttributeEnum.dataNameRemark.toString(), tDataRemark);
                tMessageSpecNode.put(ApiAttributeEnum.isDatakey.toString(), tIsDataKey);
                tMessageSpecNode.put(ApiAttributeEnum.dataType.toString(), tDataType);
                tMessageSpecNode.put(ApiAttributeEnum.canSort.toString(), tCanSort);
                tMessageSpecNode.put(ApiAttributeEnum.canFilter.toString(), tCanFilter);
                tMessageSpecNode.put(ApiAttributeEnum.isRequired.toString(), tIsRequired);
                tMessageSpecNode.put(ApiAttributeEnum.isArray.toString(), tIsArray);
                tMessageSpecNode.put(ApiAttributeEnum.isBusinessKey.toString(), tIsBusinessKey);
                tMessageSpecNode.put(ApiAttributeEnum.value.toString(), tValue);
                tMessageSpecNode.put(ApiAttributeEnum.listEnum.toString(), tListEnum);
                tMessageSpecNode.put(ApiAttributeEnum.editHistory.toString(), tHistory);
                tMessageSpecNode.set(ApiAttributeEnum.productPrecision.toString(), productPrecision);
                tSpecAryNode.add(tMessageSpecNode);
            }
        }
    }
}
