/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.dao.impl.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiDataNameDao;
import com.digiwin.athena.apimgmt.dao.ApiMgmtStandardApiVersionDao;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.GenericDaoMybatisImpl;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.MpPage;
import com.digiwin.athena.apimgmt.dao.impl.mybatis.mapper.ApiMgmtStandardApiVersionMapper;
import com.digiwin.athena.apimgmt.enums.ApiVersionEnum;
import com.digiwin.athena.apimgmt.model.ApiCountKeyValue;
import com.digiwin.athena.apimgmt.model.DirtyData;
import com.digiwin.athena.apimgmt.model.StandardApi;
import com.digiwin.athena.apimgmt.model.StandardApiVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Repository
public class ApiMgmtStandardApiVersionDaoMybatisImpl
extends GenericDaoMybatisImpl<ApiMgmtStandardApiVersionMapper, StandardApiVersion, Long>
implements ApiMgmtStandardApiVersionDao {
    private ApiMgmtStandardApiDao apiDao;
    private ApiMgmtStandardApiDataNameDao apiDataNameDao;

    @Override
    public List<StandardApiVersion> fetch(Map<String, String> pConditions) {
        MpPage page = MpPage.from(pConditions);
        List<StandardApiVersion> verList = ((ApiMgmtStandardApiVersionMapper)this.baseMapper).fetchByConditions(pConditions, (IPage<?>)page);
        this.apiDao.fillApi(verList);
        return verList;
    }

    @Override
    public List<StandardApiVersion> getVersionByApiId(Long pId, String pUserId, String pStatus) {
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).getVersionByApiId(pId, pUserId, pStatus);
    }

    @Override
    public List<StandardApiVersion> getVersionListByApiId(Long pId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(StandardApiVersion.class).eq(StandardApiVersion::getApiId, (Object)pId);
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public Map<Long, Long> advanceStandardApiCountByVersionIds(List<Long> versionIds) {
        return (Map)((ApiMgmtStandardApiVersionMapper)this.baseMapper).advanceStandardApiCountByVersionIds(versionIds).stream().collect(CollectorUtil.toMap(v -> NumberUtil.parseLong((String)StrUtil.toStringOrNull((Object)v.getKey())), Pair::getValue, Long::sum));
    }

    @Override
    public void batchSave(List<StandardApiVersion> standardApiVersions) {
        this.batchService.saveBatch(standardApiVersions, 100);
        this.apiDataNameDao.batchSave(standardApiVersions.stream().flatMap(v -> v.getStandardApiDataNames().stream()).collect(Collectors.toList()));
    }

    @Override
    @Transactional
    public void delete(Long pId, boolean pRemoveApi) {
        if (pRemoveApi) {
            StandardApiVersion version = (StandardApiVersion)this.get(pId);
            this.apiDao.delete(version.getApiId());
        }
        this.apiDataNameDao.deleteByApiVerId(pId);
        ((ApiMgmtStandardApiVersionMapper)this.baseMapper).deleteById(pId);
    }

    @Override
    public List<StandardApiVersion> fetchApiVersionsByName(String pApiName, String branch, String pTenantId) {
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).fetchApiVersionsByNameSimple(pApiName, branch, pTenantId);
    }

    @Override
    public List<StandardApiVersion> fetchApiVersionsByName(String pApiName, String branch, String pTenantId, String tTenantId, String teamType, boolean pViewAllApi) {
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).fetchApiVersionsByNameWithAuth(pApiName, branch, tTenantId, pTenantId, teamType, pViewAllApi);
    }

    @Override
    public List<StandardApiVersion> getByStatus(Long pStatus, String pUserId, String pTenantId, boolean pIsVerifyAcct) {
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).getByStatus(pStatus, pUserId, pTenantId, pIsVerifyAcct);
    }

    @Override
    public List<ApiCountKeyValue> getApiCountByStatus(String pUserId, String pTenantId, boolean pIsVerifyAcct) {
        List<Integer> approvedStatus = pIsVerifyAcct ? StandardApiVersion.Status.needVerifyAcct() : StandardApiVersion.Status.notNeedVerifyAcct();
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).getApiCountByStatus(pUserId, pTenantId, pIsVerifyAcct, approvedStatus);
    }

    @Override
    public StandardApiVersion fetchApiVersion(Map<String, String> pConditions) {
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).fetchApiVersion(pConditions);
    }

    @Override
    public List<StandardApiVersion> fetchApiVersions(String pApiName, String pVersion) {
        return this.fetchApiVersions(pApiName, "", pVersion);
    }

    @Override
    public List<StandardApiVersion> fetchApiVersions(String pApiName, String pTenantId, String pVersion) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put(ApiVersionEnum.API_NAME.toString(), pApiName);
        conditions.put(ApiVersionEnum.TENANT_ID_FULL_MATCHING.toString(), (String)StringUtils.defaultIfBlank((CharSequence)pTenantId, (CharSequence)""));
        conditions.put(ApiVersionEnum.API_VERSION.toString(), pVersion);
        conditions.put(ApiVersionEnum.APPROVED_STATUS.toString(), String.valueOf((Object)StandardApiVersion.Status.DEVELOPING));
        return this.fetch(conditions);
    }

    @Override
    public void fillApiLatestVersion(List<StandardApi> apiList) {
        if (CollUtil.isNotEmpty(apiList)) {
            return;
        }
        Map<Long, StandardApiVersion> apiIdMap = ((ApiMgmtStandardApiVersionMapper)this.baseMapper).selectLatestByApiId(apiList.stream().map(StandardApi::getId).collect(Collectors.toList()));
        apiList.forEach(ver -> ver.setStandardApiVersions(CollUtil.toList((Object[])new StandardApiVersion[]{(StandardApiVersion)apiIdMap.get(ver.getId())})));
    }

    @Override
    public List<StandardApiVersion> getExistApiVersion(String pApiName, String pTenantId, String pVersion) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put(ApiVersionEnum.API_NAME.toString(), pApiName);
        conditions.put(ApiVersionEnum.TENANT_ID_FULL_MATCHING.toString(), pTenantId);
        conditions.put(ApiVersionEnum.API_VERSION.toString(), pVersion);
        return this.fetch(conditions);
    }

    @Override
    public List<StandardApiVersion> getByCategory(Long pCategory, String pTenantId, String teamType, boolean pViewAllApi) {
        List<StandardApiVersion> list = ((ApiMgmtStandardApiVersionMapper)this.baseMapper).getByCategory(pCategory, pTenantId, teamType, pViewAllApi);
        this.apiDao.fillApi(list);
        return list;
    }

    @Override
    public List<DirtyData> queryDirtyData() {
        return ((ApiMgmtStandardApiVersionMapper)this.baseMapper).queryDirtyData();
    }

    @Autowired
    @Lazy
    public void setApiDao(ApiMgmtStandardApiDao apiDao) {
        this.apiDao = apiDao;
    }

    @Autowired
    @Lazy
    public void setApiDataNameDao(ApiMgmtStandardApiDataNameDao apiDataNameDao) {
        this.apiDataNameDao = apiDataNameDao;
    }

    @Generated
    public ApiMgmtStandardApiVersionDaoMybatisImpl() {
    }
}

