package com.digiwin.athena.apimgmt.model;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;

public class StandardApiExtendDTO {
    /**
     * api子类型; extend
     */
    private String subType;

    /**
     * 是否同步MDC
     */
    private Boolean syncMdc;


    public static StandardApiExtendDTO fromJson(String apiExtend) {
        if (StrUtil.isBlank(apiExtend)) {
            return null;
        }

        return JSONObject.parseObject(apiExtend, StandardApiExtendDTO.class);
    }

    public static StandardApiExtendDTO fromApi(StandardApi api) {
        if (api == null || StrUtil.isBlank(api.getApiExtend())) {
            return null;
        }

        return JSONObject.parseObject(api.getApiExtend(), StandardApiExtendDTO.class);
    }

    public Boolean getSyncMdc() {
        return syncMdc;
    }

    public void setSyncMdc(Boolean syncMdc) {
        this.syncMdc = syncMdc;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }
}
