package com.digiwin.athena.apimgmt.common.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Getter;
import lombok.Setter;

public class JacksonJsonSerializer implements JsonSerializer {
    @Getter
    @Setter
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> T deserialize(String json, Class<T> clazz) {
        try {
            return objectMapper.readValue(json, clazz);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }

    @Override
    public <T> T deserialize(String json, Class<?> clazz, Class<?>... genericClass) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(clazz, genericClass);
            return objectMapper.readValue(json, javaType);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }


    @Override
    public <T> T deserialize(String json, TypeReference<T> typeReference) {
        try {
            return objectMapper.readValue(json, typeReference.toJackson());
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }

    @Override
    public String serialize(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json反序列化异常！", e);
        }
    }
}
