/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.common.json;

import com.digiwin.athena.apimgmt.common.json.JsonSerializer;
import com.digiwin.athena.apimgmt.common.json.TypeReference;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;

public class JacksonJsonSerializer
implements JsonSerializer {
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> T deserialize(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public <T> T deserialize(String json, Class<?> clazz, Class<?> ... genericClass) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(clazz, (Class[])genericClass);
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public <T> T deserialize(String json, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(json, typeReference.toJackson());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public String serialize(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("json\u53cd\u5e8f\u5217\u5316\u5f02\u5e38\uff01", e);
        }
    }

    @Generated
    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @Generated
    public static void setObjectMapper(ObjectMapper objectMapper) {
        JacksonJsonSerializer.objectMapper = objectMapper;
    }
}

