package com.digiwin.athena.apimgmt.exception;


import com.digiwin.athena.apimgmt.enums.GenericStateEnum;


public class BaseException extends Exception {

    private static final long serialVersionUID = 1L;

    private GenericStateEnum stateEnum;

    /**
     * The Cause of this exception, could be null
     */
    final protected Throwable gSourceException;


    /**
     * Constructor for unchecked exception
     *
     * @param pClazz pClazz
     */
    public BaseException(Class<?> pClazz, GenericStateEnum pStateEnum) {
        super();
        setStateEnum(pStateEnum);
        this.gSourceException = null;
    }

    /**
     * Constructor for checked exception
     *
     * @param pExceptionMsg pExceptionMsg
     * @param pClazz        pClazz
     */
    public BaseException(String pExceptionMsg, Class<?> pClazz, GenericStateEnum pStateEnum) {
        super(pExceptionMsg);
        setStateEnum(pStateEnum);
        this.gSourceException = null;
    }

    /**
     * Constructor
     *
     * @param pSrcException pSrcException
     * @param pClazz        pClazz
     */
    public BaseException(Throwable pSrcException, Class<?> pClazz, GenericStateEnum pStateEnum) {
        super(pSrcException);
        setStateEnum(pStateEnum);
        this.gSourceException = pSrcException;
    }

    /**
     * Constructor for checked exception
     *
     * @param pExceptionMsg pExceptionMsg
     * @param pSrcException pSrcException
     * @param pClazz        pClazz
     */
    public BaseException(String pExceptionMsg, Throwable pSrcException, Class<?> pClazz, GenericStateEnum pStateEnum) {
        super(pExceptionMsg, pSrcException);
        setStateEnum(pStateEnum);
        this.gSourceException = pSrcException;
    }

    public GenericStateEnum getStateEnum() {
        return stateEnum;
    }

    public void setStateEnum(GenericStateEnum pStateEnum) {
        this.stateEnum = pStateEnum;
    }

}