package com.digiwin.athena.apimgmt.common.util;

import com.digiwin.athena.apimgmt.common.json.JsonSerializer;
import com.digiwin.athena.apimgmt.common.json.TypeReference;
import lombok.Getter;
import lombok.Setter;

public class JsonUtil {
    @Getter
    @Setter
    private static JsonSerializer jsonSerializer;

    private JsonUtil() {
    }

    /**
     * @see JsonSerializer#deserialize(String, Class)
     */
    public static <T> T deserialize(String json, Class<T> clazz) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        return jsonSerializer.deserialize(json, clazz);
    }

    /**
     * @see JsonSerializer#deserialize(String, Class, Class[])
     */
    public static <T> T deserialize(String json, Class<?> clazz, Class<?>... genericClass) {
        if (json == null || json.isEmpty()) {
            return null;
        }

        return jsonSerializer.deserialize(json, clazz, genericClass);
    }

    /**
     * @see JsonSerializer#deserialize(String, TypeReference)
     */
    public static <T> T deserialize(String json, TypeReference<T> typeReference) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        return jsonSerializer.deserialize(json, typeReference);
    }

    /**
     * @see JsonSerializer#serialize(Object)
     */
    public static String serialize(Object obj) {
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj == null) {
            return null;
        }

        return jsonSerializer.serialize(obj);
    }

}
