package com.digiwin.athena.apimgmt.enums;

/**
 * 词汇类型
 */
public enum DataTypeEnum {

    STRING("string"),

    NUMERIC("number"),

    DATE("string"),

    BOOLEAN("boolean"),

    DATETIME("string"),

    TIME("string");

    private final String dataType;

    DataTypeEnum(String dataType) {
        this.dataType = dataType;
    }

    public String toJsonDataType() {
        return dataType;
    }

    public static String toJsonDataType(String pArg) {
        if (null == pArg)
            return null;

        for (DataTypeEnum tEnum : DataTypeEnum.values()) {
            if (tEnum.toString().equals(pArg.toUpperCase())) {
                return tEnum.dataType;
            }
        }

        return null;
    }
}
