package com.digiwin.athena.apimgmt.constants;


/**
 * 协议常量类
 */
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ProtocolConstants {


	public final static String EMPTY = "";

	/* 协议名称 */
	public final static String HTTP_NAME = "HTTP";

	public final static String HTTPS_NAME = "HTTPS";

	/* 协议代码 */
	public final static String HTTP_CODE = "HTTP";

	public final static String HTTPS_CODE = "HTTPS";

	/* 协议数组 */
	public final static String[] PROTOCOL_ARRAY = { HTTP_NAME, HTTPS_NAME };

	/**
	 * 根据协议名称获取协议代码
	 * @param pName 协议名称
	 * @return 协议代码
	 */
	public static String getCodeByName(String pName) {
		String tReturn;
		switch (pName) {
		case HTTP_NAME:
			tReturn = HTTP_CODE;
			break;
		case HTTPS_NAME:
			tReturn = HTTPS_CODE;
			break;
		default:
			tReturn = HTTP_NAME; // 默认返回HTTP
			log.error("Invalid Protocol Name: " + pName);
		}
		return tReturn;
	}

	/**
	 * 根据协议代码获取协议名称
	 * @param pCode 协议代码
	 * @return 协议名称
	 */
	public static String getNameByCode(String pCode) {
		String tReturn;
		if (HTTP_CODE.equals(pCode)) {
			tReturn = HTTP_NAME;
		} else if (HTTPS_CODE.equals(pCode)) {
			tReturn = HTTPS_NAME;
		} else {
			tReturn = EMPTY;
			log.error("Invalid Protocol Code: " + pCode);
		}
		return tReturn;
	}
}
