package com.digiwin.athena.apimgmt.enums;

import com.digiwin.athena.apimgmt.constants.ApiTypeConstants;


public enum APIExportImportEnums {

	/**
	 * 必要欄位未填寫
	 */
	REQUIRED,

	/**
	 * 欄位「類型」為HF、MF、D、DF、SD或SDF一定要有「所屬單頭/身」
	 */
	FATHER_REQUIRED,

	/**
	 * 成功
	 */
	SUCCESS,

	/**
	 * 未匯入任何API
	 */
	NO_IMPORTABLE_API,

	/**
	 * 结果
	 */
	RESULT,

	/**
	 * 结果信息
	 */
	RESULT_MESSAGE,

	/**
	 * 「辭彙代號」不存在
	 */
	DATANAME_NOT_EXIST,

	/**
	 * 「辭彙代號」已存在於相同「所屬單頭/身」下
	 */
	DUPLICATE_DATANAME,

	/**
	 * 模版格式不正確
	 */
	INCORRECT_SHEET_FORMAT,

	/**
	 * 旧模板
	 */
	OLD_SHEET_FORMAT,

	/**
	 * 資料格式/內容有誤，請參考範例模版
	 */
	INCORRECT_FORMAT_OR_CONTENT,

	/**
	 * 長度精度格式錯誤
	 */
	INCORRECT_FORMAT_OF_PRECISION,

	/**
	 * API上一版本不存在
	 */
	PREVI_API_VERSION_IS_EXIST,

    /**
     * API上一分支不存在
     */
    PREV_API_BRANCH_NOT_EXIST,

    /**
	 * API 已存在
	 */
	API_VERSION_IS_EXIST,

	/**
	 * Map裡找不到對應父節點
	 */

	CAN_NOT_FIND_FATHER,

	/**
	 * 非get類型的API，不可使用分頁機制「2.僅支持分頁」、「3.同時支持」
	 */
	CAN_NOT_PAGING,

	/**
	 * 非get類型的API，不可使用分包機制
	 */
	CAN_NOT_BATCH,

	/**
	 * 未知錯誤
	 */
	UNKNOW_ERROR,

	/**
	 * 列舉值欄位格式錯誤
	 */
	LIST_ENUM_FORMAT_ERROR,

	/**
	 * 無效的產品名稱
	 */
	INVALID_PROD_NAME,

	/**
	 * 長度精度資訊未輸入產品名稱
	 */
	NO_INPUT_PROD_NAME,

	/**
	 * API名稱不正確，須由「小寫英文」和「.」組成，不可有其它符號或空格
	 */
	APINAME_WRONG,

    /**
     * API名稱不正確，須由「大小寫英文」和「.」組成，不可有其它符號或空格
     */
    OPEN_API_NAME_WRONG,

	/**
	 * 「須分包」與上一版不一致
	 */
	IS_BATCH_CAN_NOT_CHANGE,

	/**
	 * 「調用模式」與上一版不一致
	 */
	SYNC_TYPE_CAN_NOT_CHANGE,

	/**
	 * API上一版本為「草稿」或「開發中」
	 */
	PREVI_IS_DEVELOPING,

	/**
	 * 該字段類型不可為E
	 */
	DATA_TYPE_WRONG,

	/**
	 * 該字段的辭彙型態不可填寫長度和精度
	 */
	CAN_NOT_INPUT_PRECISIONS,

	/**
	 *  版本输入不合规
	 */
	API_VERSION_NOT_COMPLIANCE,

	/**
	 *  父类API不一致
	 */
	PARENT_NAME_INCONSISTENT,

	/**
	 *  父类API未定版
	 */
	PARENT_API_NOT_CONFIRMED,

	/**
	 * 产品不存在
	 */
	PROJECT_NOT_EXIST,

	/**
	 * 产品版本不存在
	 */
	PROJECT_VERSION_NOT_EXIST
    ;

    public static String apiNameWrong(String apiType) {
        if (ApiTypeConstants.ESP_CODE.equals(apiType)) {
            return APINAME_WRONG.toString();
        } else if (ApiTypeConstants.OPENAPI_CODE.equals(apiType)) {
            return OPEN_API_NAME_WRONG.toString();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static long apiNameWrongDescId(String apiType) {
        if (ApiTypeConstants.ESP_CODE.equals(apiType)) {
            return 2L;
        } else if (ApiTypeConstants.OPENAPI_CODE.equals(apiType)) {
            return 201L;
        } else {
            throw new IllegalArgumentException();
        }
    }
}
