package com.digiwin.athena.apimgmt.common.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import lombok.Getter;
import lombok.Setter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;


@Getter
public abstract class TypeReference<T> implements Type {
    private final Type type;

    public TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType) superClass).getActualTypeArguments()[0];
    }


    public JavaType toJackson() {
        return JacksonHolder.typeFactory.constructType(this.type);
    }

    public Type toFastJon() {
        return getType();
    }

    public String toString() {
        return this.type.toString();
    }

    public static class JacksonHolder {
        @Getter
        @Setter
        private static TypeFactory typeFactory = TypeFactory.defaultInstance();
    }

}
