package com.digiwin.athena.apimgmt.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {

    public static final String FORMAT_TO_SECOND = "yyyy-MM-dd HH:mm:ss";

    public static final String FORMAT_TO_SIMPLE_SECOND = "yyyyMMddHHmmssSSS";

    /**
     * 时间格式转换
     *
     * @param date date
     * @return String
     */
    public static String formatToSecond(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_TO_SECOND);
        return df.format(date);
    }

    /**
     * 时间格式转换
     *
     * @param date date
     * @return String
     */
    public static String formatToSimpleSecond(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_TO_SIMPLE_SECOND);
        return df.format(date);
    }

    /**
     * 时间格式转换
     *
     * @param time time
     * @return String
     */
    public static Date parasToSecond(String time) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_TO_SECOND);
        return df.parse(time);
    }
}
