package com.digiwin.athena.apimgmt.constants;


import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SyncTypeConstants {


	public final static String EMPTY = "";

	/* Name */
	public final static String SYNC_NAME = "1.同步";

	public final static String FASYNC_NAME = "2.全異步";

	/* Code */
	public final static Long SYNC_CODE = 1L;

	public final static Long FASYNC_CODE = 2L;

	public final static String[] SYNC_TYPE_ARRAY = { SYNC_NAME, FASYNC_NAME };

	public static Long getCodeByName(String pName) {
		long tReturn;
		switch (pName) {
		case SYNC_NAME:
			tReturn = SYNC_CODE;
			break;
		case FASYNC_NAME:
			tReturn = FASYNC_CODE;
			break;
		default:
			tReturn = -1L;
			log.error("Invalid Sync Type Name: " + pName);
		}
		return tReturn;
	}

	public static String getNameByCode(Long pCode) {
		String tReturn;
		if (SYNC_CODE.equals(pCode)) {
			tReturn = SYNC_NAME;
		} else if (FASYNC_CODE.equals(pCode)) {
			tReturn = FASYNC_NAME;
		} else {
			tReturn = EMPTY;
			log.error("Invalid Sync Type Code: " + pCode);
		}
		return tReturn;
	}
}
