package com.digiwin.athena.apimgmt.rest;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWFile;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.apimgmt.dto.Pagination;
import com.digiwin.athena.apimgmt.dto.ProjectDto;
import com.digiwin.athena.apimgmt.dto.Response;
import com.digiwin.athena.apimgmt.model.ProjectVersion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * API Mgmt接口服務
 */
@DWRestfulService
public interface IApiMgmtService extends DWService {

    /**
     * 取得單支API詳細信息
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDetail/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiDetailGet(DWRestfulRequest request) throws Exception;

    /**
     * 取得單支API詳細信息
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDetail/getByName", method = {DWRequestMethod.POST})
    Map<String, Object> apiDetailGetByName(DWRestfulRequest request) throws Exception;

    /**
     * API檢查
     */
    @DWRequestMapping(path = "/ApiImport/Check", method = {DWRequestMethod.POST})
    Map<String, Object> apiImportCheck(DWFile file, DWRestfulRequest request) throws Exception;

    /**
     * API導入
     */
    @DWRequestMapping(path = "/ApiImport/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiImport(DWFile file, DWRestfulRequest request) throws Exception;

    /**
     * 取得API详情規格檔
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/MessageExampleFile/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiMessageExampleFileGet(DWRestfulRequest request) throws Exception;

    /**
     * 取得API規格檔或範例模板
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiSpecFile/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiSpecFileGet(DWRestfulRequest request) throws Exception;

    /**
     * 取得信息類別清單
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiCategory/Get", method = {DWRequestMethod.GET})
    ArrayList<?> apiCategoryGet(DWRestfulRequest request) throws Exception;

    /**
     * 取得API清單
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiList/Get", method = {DWRequestMethod.POST})
    ArrayList<?> apiListGet(DWRestfulRequest request) throws Exception;

    /**
     * 取得查詢條件清單
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/SearchConditionList/Get", method = {DWRequestMethod.POST})
    Map<String, Object> searchConditionListGet(DWRestfulRequest request) throws Exception;

    /**
     * 進階查詢
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/AdvanceSearchApiList/Get", method = {DWRequestMethod.POST})
    ArrayList<?> advanceSearchApiListGet(DWRestfulRequest request) throws Exception;

    /**
     * 進階查詢
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/AdvanceSearchApiListOther/Get", method = {DWRequestMethod.POST})
    Map<String, Object> advanceSearchApiListOtherGet(DWRestfulRequest request) throws Exception;

    /**
     * 進階查詢-标准api-个数
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/AdvanceSearchApiCount/Get", method = {DWRequestMethod.POST})
    Map<String, Object> advanceSearchApiCount(DWRestfulRequest request) throws Exception;

    /**
     * 取得API狀態清單
     */
    @DWRequestMapping(path = "/ApiStatusList/Get", method = {DWRequestMethod.POST})
    ArrayList<?> apiStatusListGet(DWRestfulRequest request) throws Exception;

    /**
     * 取得API清單(狀態)
     */
    @DWRequestMapping(path = "/ApiListByStatus/Get", method = {DWRequestMethod.POST})
    ArrayList<?> apiListByStatusGet(DWRestfulRequest request) throws Exception;

    /**
     * API送審
     */
    @DWRequestMapping(path = "/ApiReview/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiReviewUpdate(DWRestfulRequest request) throws Exception;

    /**
     * API刪除
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDelete/Delete", method = {DWRequestMethod.POST})
    Map<String, Object> apiDelete(DWRestfulRequest request) throws Exception;

//    /**
//     * API刪除
//     */
//    @DWRequestMapping(path = "/DeleteApi/Delete", method = {DWRequestMethod.POST})
//    Map<String, Object> deleteApi(DWRestfulRequest request) throws Exception;

    /**
     * API審核通過
     */
    @DWRequestMapping(path = "/ApiExaminationPassed/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiExaminationPassedUpdate(DWRestfulRequest request) throws Exception;

    /**
     * API退回
     */
    @DWRequestMapping(path = "/ApiReject/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiRejectUpdate(DWRestfulRequest request) throws Exception;

    /**
     * API定版
     */
    @DWRequestMapping(path = "/ApiComfirmed/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiComfirmedUpdate(DWRestfulRequest request) throws Exception;

    /**
     * API規格取回
     */
    @DWRequestMapping(path = "/ApiSpecRetrieve/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiSpecRetrieveUpdate(DWRestfulRequest request) throws Exception;

    /**
     * API設計進階查詢
     */
    @DWRequestMapping(path = "/ApiDesignAdvanceSearchList/Get", method = {DWRequestMethod.POST})
    ArrayList<?> apiDesignAdvanceSearchListGet(DWRestfulRequest request) throws Exception;

    /**
     * 查詢API審核歷程
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiApprovedProcess/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiApprovedProcessGet(DWRestfulRequest request) throws Exception;

    /**
     * 新增辭彙
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDataName/Add", method = {DWRequestMethod.POST})
    Map<String, Object> apiDataNameAdd(DWRestfulRequest request) throws Exception;

    /**
     * 刪除辭彙
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDataName/Delete", method = {DWRequestMethod.POST})
    Map<String, Object> apiDataNameDelete(DWRestfulRequest request) throws Exception;

    /**
     * 取得API規格下拉選項欄位與清單值
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/DropdownMenu/Get", method = {DWRequestMethod.GET})
    Map<String, Object> dropdownMenuGet(DWRestfulRequest request) throws Exception;

    /**
     * 複製API規格
     */
    @DWRequestMapping(path = "/DuplicateApi/Get", method = {DWRequestMethod.POST})
    Map<String, Object> duplicateApiGet(DWRestfulRequest request) throws Exception;

    /**
     * 保存API規格
     */
    @DWRequestMapping(path = "/ApiSpec/Save", method = {DWRequestMethod.POST})
    Map<String, Object> apiSpecSave(DWRestfulRequest request) throws Exception;

    /**
     * JSON智能識別導入
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/JsonReqImport/Get", method = {DWRequestMethod.POST})
    Map<String, Object> JsonReqImportGet(DWRestfulRequest request) throws Exception;

    /**
     * 詞彙快速查找
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDateNameSearch/Get", method = {DWRequestMethod.POST})
    Map<String, Object> datanameSearchGet(String dataName) throws Exception;

    /**
     * 詞彙重新載入
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiDateNameSearch/Reload", method = {DWRequestMethod.POST})
    Map<String, Object> datanameSearchReload() throws Exception;

    /**
     * 未审批词典导入
     */
    @DWRequestMapping(path = "/StandardDate/Import", method = {DWRequestMethod.POST})
    Map<String, Object> standardDateImport(DWFile file) throws Exception;

    /**
     * 未审批词典导出
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/StandardDate/Export", method = {DWRequestMethod.POST})
    Object standardDateExport() throws Exception;

    /**
     * 获取新增|进阶版本号
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiVersion/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiVersionGet(DWRestfulRequest request) throws Exception;

    /**
     * 获取新增的分支号
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiBranch/Get", method = {DWRequestMethod.POST})
    Map<String, Object> apiBranchGet(DWRestfulRequest request) throws Exception;

    /**
     * 更新API的创建人信息
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiBuilder/Update", method = {DWRequestMethod.POST})
    Map<String, Object> apiBuilderUpdate(DWRestfulRequest request) throws Exception;

    /**
     * 批量创建API并送审
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/ApiSpec/BatchSave", method = {DWRequestMethod.POST})
    Map<String, Object> apiSpecBatchSave(DWRestfulRequest request) throws Exception;


    /**
     * 标准api查询导出规格
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/StandardApiQuery/Export", method = {DWRequestMethod.POST})
    Map<String, Object> standardApiQueryExport(DWRestfulRequest request) throws Exception;

    /**
     * 标准api查询导出列表
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/StandardApiQueryList/Export", method = {DWRequestMethod.POST})
    Map<String, Object> standardApiQueryListExport(DWRestfulRequest request) throws Exception;

    /**
     * api脏数据查询
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/dirtyData/query", method = {DWRequestMethod.POST})
    List<Long> queryDirtyData(DWRestfulRequest request) throws Exception;


    /**
     * 分页查询项目
     * @param request
     * @return
     */
    @DWRequestMapping(path = "/project/queryProjectPage", method = {DWRequestMethod.POST})
    Response<Pagination<ProjectDto>> queryProjectPage(DWRestfulRequest request);

    /**
     * 查询所有项目
     * @return
     */
    @DWRequestMapping(path = "/project/queryAllProject", method = {DWRequestMethod.GET})
    Response<List<ProjectDto>> queryAllProject();

    /**
     * 查询项目下的版本
     * @param projectId
     * @return
     */
    @DWRequestMapping(path = "/project/queryProjectVersion", method = {DWRequestMethod.GET})
    Response<List<ProjectVersion>> queryProjectVersion(DWRestfulRequest request);
    @DWRequestMapping(path = "/project/addProject", method = {DWRequestMethod.POST})
    Response<Boolean> addProject(DWRestfulRequest request) throws Exception;
    @DWRequestMapping(path = "/project/getProjectDetail", method = {DWRequestMethod.GET})
    Response<ProjectDto> getProjectDetail(DWRestfulRequest request) throws Exception;
    @DWRequestMapping(path = "/project/deleteProject", method = {DWRequestMethod.GET})
    Response<Boolean> deleteProject(DWRestfulRequest request) throws Exception;
    @DWRequestMapping(path = "/project/updateProject", method = {DWRequestMethod.POST})
    Response<Boolean> updateProject(DWRestfulRequest request) throws Exception;
    @DWRequestMapping(path = "/project/apiBindProjectVersion", method = {DWRequestMethod.POST})
    Response<Boolean> apiBindProjectVersion(DWRestfulRequest request) throws Exception;
}
