package com.digiwin.athena.apimgmt.rest.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWFile;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRestfulRequest;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.apiservice.*;
import com.digiwin.athena.apimgmt.cache.GuavaLocalCache;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.dto.*;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import com.digiwin.athena.apimgmt.rest.IApiMgmtService;
import com.digiwin.athena.apimgmt.service.util.DevelopmentPlatformServiceUtil;
import com.digiwin.athena.apimgmt.service.util.IamVerifyServiceUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import cn.hutool.core.collection.CollUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * API Mgmt接口服務
 */
@Slf4j
public class ApiMgmtService implements IApiMgmtService {


    ObjectMapper mapper = new ObjectMapper();

    @Autowired
    private ApiDetailGetService apiDetailGetService;

    @Autowired
    private ApiDetailGetByNameService apiDetailGetByNameService;

    @Autowired
    private ApiSpecFileGetService apiSpecFileGetService;

    @Autowired
    private ApiMessageExampleFileGetService apiMessageExampleFileGetService;

    @Autowired
    private ApiImportCheckService apiImportCheckService;

    @Autowired
    private ApiImportService apiImportService;

    @Autowired
    private ApiCategoryGetService apiCategoryGet;

    @Autowired
    private ApiListGetService apiListGet;

    @Autowired
    private ApiMgmtSearchConditionListGetService searchConditionListGetService;

    @Autowired
    private AdvanceSearchApiListGetService advanceSearchApiListGetService;

    @Autowired
    private ApiStatusListGetService apiStatusListGetService;

    @Autowired
    private ApiListByStatusGetService apiListByStatusGetService;

    @Autowired
    private ApiReviewUpdateService apiReviewUpdateService;

    @Autowired
    private ApiDeleteService apiDeleteService;

    @Autowired
    private DeleteApiService deleteApiService;

    @Autowired
    private ApiExaminationPassedUpdateService apiExaminationPassedUpdateService;

    @Autowired
    private ApiRejectUpdateService apiRejectUpdateService;

    @Autowired
    private ApiComfirmedUpdateService apiComfirmedUpdateService;

    @Autowired
    private ApiSpecRetrieveUpdateService apiSpecRetrieveUpdateService;

    @Autowired
    private ApiDesignAdvanceSearchListGetService apiDesignAdvanceSearchListGetService;

    @Autowired
    private ApiApprovedProcessGetService apiApprovedProcessGetService;

    @Autowired
    private ApiDataNameAddService apiDataNameAddService;

    @Autowired
    private ApiDataNameDeleteService apiDataNameDeleteService;

    @Autowired
    private ApiMgmtDropdownMenuGetService dropdownMenuGetService;

    @Autowired
    private DuplicateApiGetService duplicateApiGetService;

    @Autowired
    private ApiSpecSaveService apiSpecSaveService;

    @Autowired
    private ApiMgmtJsonReqImportGetService jsonReqImportGetService;

    @Autowired
    private DataNameSearchService dataNameSearchService;

    @Autowired
    private ApiMgmtStandardDataImportService standardDataImportService;

    @Autowired
    private ApiMgmtStandardDataExportService standardDataExportService;

    @Autowired
    private ApiSearchVersionService apiSearchVersionService;

    @Autowired
    private ApiBranchGetService apiBranchGetService;

    @Autowired
    private ApiBuilderUpdateService apiBuilderUpdateService;

    @Autowired
    private ApiSpecBatchSaveService apiSpecBatchSaveService;

    @Autowired
    private StandardApiQueryExportService standardApiQueryExportService;

    @Autowired
    private StandardApiQueryListExportService standardApiQueryListExportService;

    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;

    @Autowired
    private AdvanceSearchApiListGetCountService advanceSearchApiListGetCountService;

    @Autowired
    private ApiMgmtQueryDirtyDataService queryDirtyDataService;

    @Autowired
    private ApiMgmtAuthService apiMgmtAuthService;

    @Autowired
    private GuavaLocalCache guavaLocalCache;

    @Autowired
    private ApiMgmtProjectService projectService;

    private static final Lock LOCK = new ReentrantLock(true);

    /**
     * 取得單支API詳細信息
     */
    @Override
    public Map<String, Object> apiDetailGet(DWRestfulRequest request) throws Exception {
        return apiDetailGetService.execute(request.getBodyAsString());
    }

    /**
     * 取得單支API詳細信息
     */
    @Override
    public Map<String, Object> apiDetailGetByName(DWRestfulRequest request) throws Exception {
        return apiDetailGetByNameService.execute(request.getBodyAsString());
    }

    /**
     * 取得API規格檔或範例模板
     */
    @Override
    public Map<String, Object> apiSpecFileGet(DWRestfulRequest request) throws Exception {
        return apiSpecFileGetService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> apiMessageExampleFileGet(DWRestfulRequest request) throws Exception {
        return apiMessageExampleFileGetService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> apiImportCheck(DWFile file, DWRestfulRequest request) throws Exception {
        FileDto dwFile =
                BeanUtil.copyProperties(file, FileDto.class);
        if (authJudge()) {
            return apiImportCheckService.execute(dwFile);
        } else {
            try {
                return apiMgmtAuthService.apiImportCheckV2(dwFile, request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    @Override
    public Map<String, Object> apiImport(DWFile file, DWRestfulRequest request) throws Exception {
        FileDto dwFile =
                BeanUtil.copyProperties(file, FileDto.class);
        if (authJudge()) {
            return apiImportService.execute(dwFile);
        } else {
            try {
                return apiMgmtAuthService.apiImportV2(dwFile, request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * 取得信息類別清單
     */
    @Override
    public ArrayList<Map<String, Object>> apiCategoryGet(DWRestfulRequest request) {
        return apiCategoryGet.execute(request.getBodyAsString());
    }

    /**
     * 取得API清單
     */
    @Override
    public ArrayList<Map<String, Object>> apiListGet(DWRestfulRequest request) throws Exception {
        return apiListGet.execute(request.getBodyAsString());
    }

    /**
     * 取得查詢條件清單
     */
    @Override
    public Map<String, Object> searchConditionListGet(DWRestfulRequest request) throws Exception {
        return searchConditionListGetService.execute(request.getBodyAsString());
    }

    /**
     * 進階查詢
     */
    @Override
    public ArrayList<Map<String, Object>> advanceSearchApiListGet(DWRestfulRequest request) throws Exception {
        return advanceSearchApiListGetService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> advanceSearchApiListOtherGet(DWRestfulRequest request) throws Exception {
        return advanceSearchApiListGetOtherService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> advanceSearchApiCount(DWRestfulRequest request) throws Exception {
        return advanceSearchApiListGetCountService.execute(request.getBodyAsString());
    }

    /**
     * 取得API狀態清單
     */
    @Override
    public ArrayList<Map<String, Object>> apiStatusListGet(DWRestfulRequest request) throws Exception {
        return apiStatusListGetService.execute(request.getBodyAsString());
    }

    /**
     * 取得API清單(狀態)
     */
    @Override
    public ArrayList<?> apiListByStatusGet(DWRestfulRequest request) throws Exception {
        return apiListByStatusGetService.execute(request.getBodyAsString());
    }

    /**
     * API送審
     */
    @Override
    public Map<String, Object> apiReviewUpdate(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiReviewUpdateService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiReviewUpdateV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * API刪除
     */
    @Override
    public Map<String, Object> apiDelete(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiDeleteService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiDeleteV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * API刪除
     */
/*    @Override
    public Map<String, Object> deleteApi(DWRestfulRequest request) throws Exception {
        return deleteApiService.execute(request.getBodyAsString());
    }*/

    /**
     * API審核通過
     */
    @Override
    public Map<String, Object> apiExaminationPassedUpdate(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiExaminationPassedUpdateService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiExaminationPassedUpdateV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * API退回
     */
    @Override
    public Map<String, Object> apiRejectUpdate(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiRejectUpdateService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiRejectUpdateV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * API定版
     */
    @Override
    public Map<String, Object> apiComfirmedUpdate(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiComfirmedUpdateService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiConfirmedUpdateV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * API規格取回
     */
    @Override
    public Map<String, Object> apiSpecRetrieveUpdate(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiSpecRetrieveUpdateService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiSpecRetrieveUpdateV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * API設計進階查詢
     */
    @Override
    public ArrayList<?> apiDesignAdvanceSearchListGet(DWRestfulRequest request) throws Exception {
        return apiDesignAdvanceSearchListGetService.execute(request.getBodyAsString());
    }

    /**
     * 查詢API審核歷程
     */
    @Override
    public Map<String, Object> apiApprovedProcessGet(DWRestfulRequest request) throws Exception {
        return apiApprovedProcessGetService.execute(request.getBodyAsString());
    }

    /**
     * 新增辭彙
     */
    @Override
    public Map<String, Object> apiDataNameAdd(DWRestfulRequest request) throws Exception {
        return apiDataNameAddService.execute(request.getBodyAsString());
    }

    /**
     * 刪除辭彙
     */
    @Override
    public Map<String, Object> apiDataNameDelete(DWRestfulRequest request) throws Exception {
        return apiDataNameDeleteService.execute(request.getBodyAsString());
    }

    /**
     * 取得API規格下拉選項欄位與清單值
     */
    @Override
    public Map<String, Object> dropdownMenuGet(DWRestfulRequest request) {
        return dropdownMenuGetService.execute(request.getBodyAsString());
    }

    /**
     * 複製API規格
     */
    @Override
    public Map<String, Object> duplicateApiGet(DWRestfulRequest request) throws Exception {
        return duplicateApiGetService.execute(request.getBodyAsString());
    }

    /**
     * 保存API規格
     */
    @Override
    public Map<String, Object> apiSpecSave(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiSpecSaveService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiSpecSaveV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    /**
     * JSON智能識別導入
     */
    @Override
    public Map<String, Object> JsonReqImportGet(DWRestfulRequest request) throws Exception {
        return jsonReqImportGetService.execute(request.getBodyAsString());
    }

    /**
     * 詞彙快速查找
     */
    @Override
    public Map<String, Object> datanameSearchGet(String dataName) throws Exception {
        return dataNameSearchService.execute(dataName);
    }

    /**
     * 詞彙重新載入
     * /restful/standard/apimgmt/ApiDateNameSearch/Reload
     */
    @Override
    public Map<String, Object> datanameSearchReload() {
        dataNameSearchService.reloadDataNameToTreeSet();
        return new HashMap<>();
    }

    @Override
    public Map<String, Object> standardDateImport(DWFile file) throws Exception {
        FileDto dwFile =
                BeanUtil.copyProperties(file, FileDto.class);
        return standardDataImportService.execute(dwFile);
    }

    @Override
    public Object standardDateExport() throws Exception {
//        return standardDataExportService.execute();
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> apiVersionGet(DWRestfulRequest request) throws Exception {
        return apiSearchVersionService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> apiBranchGet(DWRestfulRequest request) throws Exception {
        return apiBranchGetService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> apiBuilderUpdate(DWRestfulRequest request) throws Exception {
        return apiBuilderUpdateService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> apiSpecBatchSave(DWRestfulRequest request) throws Exception {
        if (authJudge()) {
            return apiSpecBatchSaveService.execute(request.getBodyAsString());
        } else {
            try {
                return apiMgmtAuthService.apiSpecBatchSaveV2(request);
            } catch (Exception e) {
                return convertJsonNodeToMap(e);
            }
        }
    }

    @Override
    public Map<String, Object> standardApiQueryExport(DWRestfulRequest request) throws Exception {
        return standardApiQueryExportService.execute(request.getBodyAsString());
    }

    @Override
    public Map<String, Object> standardApiQueryListExport(DWRestfulRequest request) throws Exception {
        return standardApiQueryListExportService.execute(request.getBodyAsString());
    }

    @Override
    public List<Long> queryDirtyData(DWRestfulRequest request) {
        return queryDirtyDataService.queryDirtyData();
    }

    @Override
    public Response<Pagination<ProjectDto>> queryProjectPage(DWRestfulRequest request) {
        try {
            PageReqCondition<String> stringPageReqCondition = JSONObject.parseObject(request.getBodyAsString(), new com.alibaba.fastjson.TypeReference<PageReqCondition<String>>() {
            });
            Pagination<ProjectDto> projectDtoPagination = projectService.queryProjectPage(stringPageReqCondition);
            return Response.buildSuccess(projectDtoPagination);
        } catch (Exception e) {
            log.error("queryProjectPage exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public Response<List<ProjectDto>> queryAllProject(){
        try {
            List<ProjectDto> projectDtos = projectService.queryProject();
            return Response.buildSuccess(projectDtos);
        } catch (Exception e) {
            log.error("queryAllProject exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public  Response<List<ProjectVersion>> queryProjectVersion(DWRestfulRequest request){
        try {
            Map<String, Object> requestParam = request.getRequestParam();
            List<ProjectVersion> projectVersions = projectService.queryProjectVersion(Long.valueOf(requestParam.get("projectId").toString()));
            return Response.buildSuccess(projectVersions);
        } catch (Exception e) {
            log.error("queryProjectVersion exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public Response<Boolean> addProject(DWRestfulRequest request)  {
        try {
            ProjectDto projectDto = JSONObject.parseObject(request.getBodyAsString(), ProjectDto.class);
            projectDto.validateFields();
            return Response.buildSuccess(projectService.addProject(projectDto));
        } catch (Exception e) {
            log.error("addProject exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public Response<ProjectDto> getProjectDetail(DWRestfulRequest request)  {
        try {
            Map<String, Object> requestParam = request.getRequestParam();
            return Response.buildSuccess(projectService.getProjectDetail(Long.valueOf(requestParam.get("projectId").toString())));
        } catch (Exception e) {
            log.error("addProject exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public Response<Boolean> deleteProject(DWRestfulRequest request)  {
        try {
            Map<String, Object> requestParam = request.getRequestParam();
            Boolean res = projectService.deleteProject(Long.valueOf(requestParam.get("projectId").toString()));
            return Response.buildSuccess(res);
        } catch (Exception e) {
            log.error("deleteProject exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public Response<Boolean> updateProject(DWRestfulRequest request) {
        try {
            ProjectDto projectDto = JSONObject.parseObject(request.getBodyAsString(), ProjectDto.class);
            projectDto.validateFields();
            Boolean res = projectService.updateProject(projectDto);
            return Response.buildSuccess(res);
        } catch (Exception e) {
            log.error("updateProject exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    @Override
    public Response<Boolean> apiBindProjectVersion(DWRestfulRequest request) {
        try {
            ApiBindProjectVersionReqDto apiBindProjectVersionReqDto = JSONObject.parseObject(request.getBodyAsString(), ApiBindProjectVersionReqDto.class);
            Boolean res = projectService.apiBindProjectVersion(apiBindProjectVersionReqDto);
            return Response.buildSuccess(res);
        } catch (Exception e) {
            log.error("apiBindProjectVersion exception:"+e.getMessage(),e);
            return Response.buildFail(e.getMessage());
        }
    }

    private Boolean authJudge() throws Exception {
        String tToken = (String) DWServiceContext.getContext().getRequestHeader().get(ApimgmtConstant.TOKEN);
        Map<String, String> userInfo = IamVerifyServiceUtil.getUserInfo(tToken);
        String tUserId = userInfo.get(ApimgmtConstant.USER_ID);
        List<String> ids = guavaLocalCache.getCache().getIfPresent("authUserWhiteList");
        if (CollUtil.isEmpty(ids)) {
            LOCK.lock();
            try {
                // 查询开发平台接口获取配置的白名单信息
                ids = guavaLocalCache.getCache().getIfPresent("authUserWhiteList");
                if (CollUtil.isEmpty(ids) && StringUtils.isNotEmpty(ApiMgmtApplicationParameter._DEV_PLATE_URL)) {
                    ids = DevelopmentPlatformServiceUtil.getWithAuthList(tToken, "apimgmtAuthUserWhiteList");
                    guavaLocalCache.getCache().put("authUserWhiteList", ids);
                }
            } finally {
                LOCK.unlock();
            }
        }
        if (CollUtil.isNotEmpty(ids)) {
            return ids.contains(tUserId);
        }
        return false;
    }

    protected Map<String, Object> convertJsonNodeToMap(Exception e) {
        ObjectNode tResponseNode = mapper.createObjectNode();
        tResponseNode.put(ApimgmtConstant.CODE, "211");
        tResponseNode.put(ApimgmtConstant.DESCRIPTION, e.getMessage());
        log.debug("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
                + ", 回傳訊息: " + tResponseNode.toString());
        return mapper.convertValue(tResponseNode, new TypeReference<Map<String, Object>>() {
        });
    }
}
