package com.digiwin.athena.apimgmt.infra.dap.http;

import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import com.digiwin.http.client.exception.DWHttpFailedException;

public class DapHttpFailedException extends HttpFailedException {
    private DWHttpFailedException httpCause;

    public DapHttpFailedException(DWHttpFailedException httpCause) {
        this.httpCause = httpCause;
    }

    public DapHttpFailedException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public int getStatusCode() {
        return httpCause != null ? httpCause.getStatusCode() : 500;
    }

    @Override
    public String getRespBody() {
        if (httpCause != null) {
            return httpCause.getEntity(String.class);
        }

        return getMessage();
    }
}
