/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.dap.http;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.stream.StreamUtil;
import com.digiwin.athena.apimgmt.common.util.JsonUtil;
import com.digiwin.athena.apimgmt.infra.dap.http.DapHttpFailedException;
import com.digiwin.athena.apimgmt.infra.http.ApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.MultipartFile;
import com.digiwin.athena.apimgmt.infra.http.RequestOption;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.exception.DWHttpFailedException;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

@Component
public class DapApiMgmtHttpClientWrapper
implements ApiMgmtHttpClientWrapper {
    private final DWHttpClient dwHttpClient;

    public DapApiMgmtHttpClientWrapper(DWHttpClient dwHttpClient) {
        this.dwHttpClient = dwHttpClient;
    }

    public <T> T execute(HttpRequest request, Class<T> responseType) {
        return this.execute(request, responseType, null);
    }

    public <T> T execute(HttpRequest request, Class<T> responseType, RequestOption options) {
        HttpUriRequest realRequest = this.buildRequest(request, options);
        return this.exchange(responseType, options, realRequest);
    }

    private <T> T exchange(Class<T> responseType, RequestOption options, HttpUriRequest realRequest) {
        DWRequestOption dwOption = new DWRequestOption(false);
        BasicHttpContext httpContext = new BasicHttpContext();
        if (options != null && !options.isRetryEnabled()) {
            httpContext.setAttribute("Time-Task", (Object)"Time-Task");
        }
        try {
            if (responseType == null || com.digiwin.athena.apimgmt.infra.http.HttpResponse.class.isAssignableFrom(responseType)) {
                HttpResponse resp = this.dwHttpClient.execute(realRequest, null, dwOption, (HttpContext)httpContext);
                return (T)this.transformResponse(resp);
            }
            return (T)this.dwHttpClient.execute(realRequest, responseType, null, dwOption, (HttpContext)httpContext);
        }
        catch (DWHttpFailedException e) {
            throw new DapHttpFailedException(e);
        }
        catch (IOException e) {
            throw new DapHttpFailedException("http\u8bf7\u6c42\u5f02\u5e38\uff01", e);
        }
    }

    public <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType) {
        return this.uploadFile(request, file, responseType, null);
    }

    public <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType, RequestOption options) {
        HttpUriRequest realRequest = this.buildMultipartRequest(request, file, options);
        return this.exchange(responseType, options, realRequest);
    }

    protected HttpUriRequest buildRequest(HttpRequest request, RequestOption options) {
        HttpEntity entity;
        RequestConfig.Builder config = this.setOptions(options);
        Object body = request.getBody();
        if (body instanceof HttpEntity) {
            entity = (HttpEntity)body;
        } else {
            StringEntity strEntity = new StringEntity(JsonUtil.serialize((Object)body), ContentType.APPLICATION_JSON);
            strEntity.setContentEncoding("UTF-8");
            strEntity.setContentType("application/json");
            entity = strEntity;
        }
        return RequestBuilder.create((String)request.getMethod()).setConfig(config.build()).setEntity(entity).setUri(request.getUrl()).build();
    }

    protected HttpUriRequest buildMultipartRequest(HttpRequest request, MultipartFile file, RequestOption options) {
        RequestConfig.Builder config = this.setOptions(options);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        this.getBodyMap(request).forEach((k, v) -> entityBuilder.addTextBody(k, JsonUtil.serialize((Object)v), ContentType.APPLICATION_JSON));
        entityBuilder.addBinaryBody(file.getName(), file.getInputStream(), ContentType.create((String)file.getContentType()), file.getFileName());
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod()).setConfig(config.build()).setEntity(entityBuilder.build()).setUri(request.getUrl());
        MapUtil.emptyIfNull((Map)request.getHeaders()).forEach((arg_0, arg_1) -> ((RequestBuilder)builder).addHeader(arg_0, arg_1));
        return builder.build();
    }

    protected RequestConfig.Builder setOptions(RequestOption options) {
        RequestConfig.Builder config = RequestConfig.custom();
        if (options != null && options.getTimeout() != null) {
            config.setSocketTimeout(options.getTimeout().intValue());
        }
        return config;
    }

    protected com.digiwin.athena.apimgmt.infra.http.HttpResponse transformResponse(HttpResponse resp) throws IOException {
        return com.digiwin.athena.apimgmt.infra.http.HttpResponse.builder().statusCode(resp.getStatusLine().getStatusCode()).header(StreamUtil.of((Object[])resp.getAllHeaders()).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue))).is(resp.getEntity().getContent()).bodyConverter(() -> {
            try {
                return EntityUtils.toString((HttpEntity)resp.getEntity());
            }
            catch (IOException e) {
                throw new DapHttpFailedException("\u89e3\u6790\u54cd\u5e94\u4f53\u5931\u8d25\uff01", e);
            }
        }).build();
    }
}

