package com.digiwin.athena.apimgmt.infra.spring.config;

import com.digiwin.athena.apimgmt.common.json.JsonSerializer;
import com.digiwin.athena.apimgmt.common.util.JsonUtil;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtServiceContext;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.http.ApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.infra.util.PathContextUtil;
import com.digiwin.athena.apimgmt.infra.util.PropertyUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 未完成全部配置静态化，所以在此处提前初始化配置相关类
 */
//@Configuration
public class ApiMgmtUtilConfig implements InitializingBean {
    @SuppressWarnings("unused")
    @Autowired
    private ApiMgmtHttpClientWrapper httpClientWrapper;
    @Autowired
    private JsonSerializer jsonSerializer;
    @Autowired
    private IApiMgmtServiceContext serviceContext;


    @Override
    public void afterPropertiesSet() {
        HttpUtil.setHttpClient(httpClientWrapper);
        JsonUtil.setJsonSerializer(jsonSerializer);
        ApiMgmtServiceContextHolder.setServiceContext(serviceContext);
    }
}
