/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.http;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.apimgmt.common.util.JsonUtil;
import com.digiwin.athena.apimgmt.infra.http.ApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.http.HttpRequest;
import com.digiwin.athena.apimgmt.infra.http.HttpResponse;
import com.digiwin.athena.apimgmt.infra.http.MultipartFile;
import com.digiwin.athena.apimgmt.infra.http.RequestOption;
import com.digiwin.athena.apimgmt.infra.spring.http.SpringHttpFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class SpringApiMgmtHttpClientWrapper
implements ApiMgmtHttpClientWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringApiMgmtHttpClientWrapper.class);
    private final RestTemplate restTemplate;
    private final Map<Integer, RestTemplate> CACHE = new ConcurrentHashMap<Integer, RestTemplate>();

    public SpringApiMgmtHttpClientWrapper(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public static RestTemplate copyWithTimeout(RestTemplate source, int timeout) {
        ClientHttpRequestFactory factory;
        RestTemplate newTemplate = new RestTemplate();
        newTemplate.setInterceptors(source.getInterceptors());
        newTemplate.setMessageConverters(source.getMessageConverters());
        newTemplate.setErrorHandler(source.getErrorHandler());
        newTemplate.setUriTemplateHandler(source.getUriTemplateHandler());
        newTemplate.setRequestFactory(source.getRequestFactory());
        if (source.getUriTemplateHandler() instanceof DefaultUriBuilderFactory) {
            newTemplate.setDefaultUriVariables(((DefaultUriBuilderFactory)source.getUriTemplateHandler()).getDefaultUriVariables());
        }
        if ((factory = source.getRequestFactory()) instanceof SimpleClientHttpRequestFactory) {
            SimpleClientHttpRequestFactory simple = (SimpleClientHttpRequestFactory)factory;
            simple.setConnectTimeout(timeout);
            simple.setReadTimeout(timeout);
            newTemplate.setRequestFactory((ClientHttpRequestFactory)simple);
        } else if (factory instanceof HttpComponentsClientHttpRequestFactory) {
            HttpComponentsClientHttpRequestFactory http = (HttpComponentsClientHttpRequestFactory)factory;
            http.setConnectTimeout(timeout);
            http.setReadTimeout(timeout);
            newTemplate.setRequestFactory((ClientHttpRequestFactory)http);
        } else {
            SimpleClientHttpRequestFactory fallback = new SimpleClientHttpRequestFactory();
            fallback.setConnectTimeout(timeout);
            fallback.setReadTimeout(timeout);
            newTemplate.setRequestFactory((ClientHttpRequestFactory)fallback);
        }
        return newTemplate;
    }

    private static ResponseExtractor<HttpResponse> transformResp() {
        return resp -> HttpResponse.builder().statusCode(resp.getStatusCode().value()).header(resp.getHeaders().toSingleValueMap()).is(resp.getBody()).bodyConverter(() -> {
            try {
                MediaType contentType = resp.getHeaders().getContentType();
                return IoUtil.read((InputStream)resp.getBody(), (Charset)(contentType != null ? contentType.getCharset() : StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new SpringHttpFailedException("\u8bfb\u53d6\u54cd\u5e94\u6d41\u5f02\u5e38!", e);
            }
        }).build();
    }

    public <T> T execute(HttpRequest request, Class<T> responseType) {
        return this.execute(request, responseType, null);
    }

    public <T> T execute(HttpRequest request, Class<T> responseType, RequestOption options) {
        RestTemplate template = this.setOptions(options);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        MapUtil.emptyIfNull((Map)request.getHeaders()).forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        Object body = request.getBody();
        String bodyStr = null;
        if (body != null) {
            bodyStr = body instanceof String ? (String)body : JsonUtil.serialize((Object)body);
        }
        HttpEntity httpEntity = new HttpEntity(bodyStr, (MultiValueMap)headers);
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod());
        if (method == null) {
            throw new IllegalArgumentException("Unsupported HTTP method: " + request.getMethod());
        }
        return this.execute(request, responseType, method, httpEntity, template);
    }

    protected RestTemplate setOptions(RequestOption options) {
        RestTemplate template = this.restTemplate;
        if (options != null && options.getTimeout() != null) {
            template = this.CACHE.computeIfAbsent(options.getTimeout(), k -> SpringApiMgmtHttpClientWrapper.copyWithTimeout(this.restTemplate, options.getTimeout()));
        }
        return template;
    }

    public <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType) {
        return this.uploadFile(request, file, responseType, null);
    }

    public <T> T uploadFile(HttpRequest request, MultipartFile file, Class<T> responseType, RequestOption options) {
        RestTemplate template = this.setOptions(options);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        MapUtil.emptyIfNull((Map)request.getHeaders()).forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        LinkedMultiValueMap reqBody = new LinkedMultiValueMap();
        this.getBodyMap(request).forEach((arg_0, arg_1) -> SpringApiMgmtHttpClientWrapper.lambda$uploadFile$3((MultiValueMap)reqBody, arg_0, arg_1));
        reqBody.add((Object)file.getName(), this.buildFileEntity(file));
        HttpEntity httpEntity = new HttpEntity((Object)reqBody, (MultiValueMap)headers);
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod());
        if (method == null) {
            throw new IllegalArgumentException("Unsupported HTTP method: " + request.getMethod());
        }
        return this.execute(request, responseType, method, httpEntity, template);
    }

    private <T> T execute(HttpRequest request, Class<T> responseType, HttpMethod method, HttpEntity<?> httpEntity, RestTemplate template) {
        try {
            if (responseType == null || responseType == HttpResponse.class) {
                return (T)this.restTemplate.execute(request.getUrl(), method, this.restTemplate.httpEntityCallback(httpEntity), SpringApiMgmtHttpClientWrapper.transformResp());
            }
            ResponseEntity response = template.exchange(request.getUrl(), method, httpEntity, responseType);
            return (T)response.getBody();
        }
        catch (RestClientResponseException e) {
            throw new SpringHttpFailedException(e);
        }
        catch (Exception e) {
            throw new SpringHttpFailedException("HTTP file upload failed: " + e.getMessage(), e);
        }
    }

    protected HttpEntity<InputStreamResource> buildFileEntity(final MultipartFile file) {
        InputStreamResource fileResource = new InputStreamResource(file.getInputStream()){

            public String getFilename() {
                return file.getFileName();
            }

            public long contentLength() {
                return file.getSize();
            }
        };
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.valueOf((String)file.getContentType()));
        return new HttpEntity((Object)fileResource, (MultiValueMap)fileHeader);
    }

    private static /* synthetic */ void lambda$uploadFile$3(MultiValueMap reqBody, String k, Object v) {
        reqBody.add((Object)k, (Object)JsonUtil.serialize((Object)v));
    }
}

