package com.digiwin.athena.apimgmt.infra.spring.auth;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.constants.ApimgmtConstant;
import com.digiwin.athena.apimgmt.infra.auth.ApiMgmtIdentity;
import com.digiwin.athena.apimgmt.infra.auth.IApiMgmtIdentityService;
import com.digiwin.athena.apimgmt.service.util.IamVerifyServiceUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtIamVerifyService;
import jakarta.annotation.Nullable;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

@Slf4j
public class ApiMgmtIamIdentityService implements IApiMgmtIdentityService {
    private final ApiMgmtIamVerifyService iamVerifyService;

    public ApiMgmtIamIdentityService(ApiMgmtIamVerifyService iamVerifyService) {
        this.iamVerifyService = iamVerifyService;
    }

    @Override
    public @Nullable String getIntegrationToken(String tenantId) {
        // TODO 外部添加緩存
        return iamVerifyService.getIntegrationToken(tenantId);
    }

    @Override
    public @Nullable String getTenantName(String tenantId) {
        // TODO 添加緩存
        ApiMgmtIdentity identity = parseToken(getIntegrationToken(tenantId));
        return identity != null ? identity.getTenantName() : null;
    }

    @Nullable
    @Override
    public ApiMgmtIdentity parseToken(String token) {
        return parseUserInfo(token);
    }


    protected ApiMgmtIdentity parseUserInfo(String token) {
        if (StrUtil.isBlank(token)) {
            return null;
        }

        try {
            Map<String, String> userInfo = iamVerifyService.getUserInfo(token);

            return ApiMgmtIdentity.builder()
                    .userId(MapUtil.getStr(userInfo, ApimgmtConstant.USER_ID))
                    .userName(MapUtil.getStr(userInfo, ApimgmtConstant.USER_NAME))
                    .tenantId(MapUtil.getStr(userInfo, ApimgmtConstant.TENANT_ID))
                    .tenantName(MapUtil.getStr(userInfo, ApimgmtConstant.TENANT_NAME))
                    .teamIdSupplier(() -> teamIdSupplier(token))
                    .teamTypeSupplier(identity -> IamVerifyServiceUtil.getTeamType(identity.getTeamId()))
                    .build();
        } catch (Exception e) {
            log.error("解析用户信息异常！", e);
            return null;
        }
    }

    protected String teamIdSupplier(String token) {
        try {
            return iamVerifyService.getTeamId(token);
        } catch (Exception e) {
            log.error("解析用户teamId异常！", e);
            return null;
        }
    }

}
