package com.digiwin.athena.apimgmt.infra.spring.http;

import com.digiwin.athena.apimgmt.infra.http.HttpFailedException;
import org.springframework.web.client.RestClientResponseException;

public class SpringHttpFailedException extends HttpFailedException {
    private RestClientResponseException httpCause;

    public SpringHttpFailedException(RestClientResponseException httpCause) {
        super(httpCause.getMessage(), httpCause.getCause());
        this.httpCause = httpCause;
    }

    public SpringHttpFailedException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public int getStatusCode() {
        return httpCause != null ? httpCause.getStatusCode().value() : 500;
    }

    @Override
    public String getRespBody() {
        if (httpCause != null) {
            return httpCause.getResponseBodyAsString();
        }

        return getMessage();
    }


    @Override
    public String getMessage() {
        if (httpCause != null) {
            return httpCause.getMessage();
        }

        return super.getMessage();
    }
}

