/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.controller;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetCountService;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiApprovedProcessGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiBranchGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiBuilderUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiCategoryGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiComfirmedUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiDataNameAddService;
import com.digiwin.athena.apimgmt.apiservice.ApiDataNameDeleteService;
import com.digiwin.athena.apimgmt.apiservice.ApiDeleteService;
import com.digiwin.athena.apimgmt.apiservice.ApiDesignAdvanceSearchListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiDetailGetByNameService;
import com.digiwin.athena.apimgmt.apiservice.ApiDetailGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiExaminationPassedUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiImportCheckService;
import com.digiwin.athena.apimgmt.apiservice.ApiImportService;
import com.digiwin.athena.apimgmt.apiservice.ApiListByStatusGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMessageExampleFileGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtDropdownMenuGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtJsonReqImportGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtProjectService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtQueryDirtyDataService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtSearchConditionListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtStandardDataExportService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtStandardDataImportService;
import com.digiwin.athena.apimgmt.apiservice.ApiRejectUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiReviewUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiSearchVersionService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecBatchSaveService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecFileGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecRetrieveUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecSaveService;
import com.digiwin.athena.apimgmt.apiservice.ApiStatusListGetService;
import com.digiwin.athena.apimgmt.apiservice.DataNameSearchService;
import com.digiwin.athena.apimgmt.apiservice.DuplicateApiGetService;
import com.digiwin.athena.apimgmt.apiservice.StandardApiQueryExportService;
import com.digiwin.athena.apimgmt.apiservice.StandardApiQueryListExportService;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.dto.ApiBindProjectVersionReqDto;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.dto.Pagination;
import com.digiwin.athena.apimgmt.dto.ProjectDto;
import com.digiwin.athena.apimgmt.dto.Response;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.spring.controller.DapCompatibleRespDTO;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/restful/standard/apimgmt"})
public class ApiMgmtController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtController.class);
    @Autowired
    private ApiDetailGetService apiDetailGetService;
    @Autowired
    private ApiDetailGetByNameService apiDetailGetByNameService;
    @Autowired
    private ApiSpecFileGetService apiSpecFileGetService;
    @Autowired
    private ApiMessageExampleFileGetService apiMessageExampleFileGetService;
    @Autowired
    private ApiImportCheckService apiImportCheckService;
    @Autowired
    private ApiImportService apiImportService;
    @Autowired
    private ApiCategoryGetService apiCategoryGet;
    @Autowired
    private ApiListGetService apiListGet;
    @Autowired
    private ApiMgmtSearchConditionListGetService searchConditionListGetService;
    @Autowired
    private AdvanceSearchApiListGetService advanceSearchApiListGetService;
    @Autowired
    private ApiStatusListGetService apiStatusListGetService;
    @Autowired
    private ApiListByStatusGetService apiListByStatusGetService;
    @Autowired
    private ApiReviewUpdateService apiReviewUpdateService;
    @Autowired
    private ApiDeleteService apiDeleteService;
    @Autowired
    private ApiExaminationPassedUpdateService apiExaminationPassedUpdateService;
    @Autowired
    private ApiRejectUpdateService apiRejectUpdateService;
    @Autowired
    private ApiComfirmedUpdateService apiComfirmedUpdateService;
    @Autowired
    private ApiSpecRetrieveUpdateService apiSpecRetrieveUpdateService;
    @Autowired
    private ApiDesignAdvanceSearchListGetService apiDesignAdvanceSearchListGetService;
    @Autowired
    private ApiApprovedProcessGetService apiApprovedProcessGetService;
    @Autowired
    private ApiDataNameAddService apiDataNameAddService;
    @Autowired
    private ApiDataNameDeleteService apiDataNameDeleteService;
    @Autowired
    private ApiMgmtDropdownMenuGetService dropdownMenuGetService;
    @Autowired
    private DuplicateApiGetService duplicateApiGetService;
    @Autowired
    private ApiSpecSaveService apiSpecSaveService;
    @Autowired
    private ApiMgmtJsonReqImportGetService jsonReqImportGetService;
    @Autowired
    private DataNameSearchService dataNameSearchService;
    @Autowired
    private ApiMgmtStandardDataImportService standardDataImportService;
    @Autowired
    private ApiMgmtStandardDataExportService standardDataExportService;
    @Autowired
    private ApiSearchVersionService apiSearchVersionService;
    @Autowired
    private ApiBranchGetService apiBranchGetService;
    @Autowired
    private ApiBuilderUpdateService apiBuilderUpdateService;
    @Autowired
    private ApiSpecBatchSaveService apiSpecBatchSaveService;
    @Autowired
    private StandardApiQueryExportService standardApiQueryExportService;
    @Autowired
    private StandardApiQueryListExportService standardApiQueryListExportService;
    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;
    @Autowired
    private AdvanceSearchApiListGetCountService advanceSearchApiListGetCountService;
    @Autowired
    private ApiMgmtQueryDirtyDataService queryDirtyDataService;
    @Autowired
    private ApiMgmtProjectService projectService;

    @PostMapping(value={"/ApiDetail/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDetailGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDetailGetService.execute(json), "apiDetailGet");
    }

    @PostMapping(value={"/ApiDetail/getByName"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDetailGetByName(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDetailGetByNameService.execute(json), "apiDetailGetByName");
    }

    @PostMapping(value={"/ApiImport/Check"})
    public DapCompatibleRespDTO<Map<String, Object>> apiImportCheck(@RequestParam(value="file") MultipartFile file) {
        return this.executeWithWrapper(() -> {
            FileDto dwFile = this.convertMultipartFileToDWFile(file);
            return this.apiImportCheckService.execute(dwFile);
        }, "apiImportCheck");
    }

    @PostMapping(value={"/ApiImport/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiImport(@RequestParam(value="file") MultipartFile file) {
        return this.executeWithWrapper(() -> {
            FileDto dwFile = this.convertMultipartFileToDWFile(file);
            return this.apiImportService.execute(dwFile);
        }, "apiImport");
    }

    @PostMapping(value={"/MessageExampleFile/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiMessageExampleFileGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiMessageExampleFileGetService.execute(json), "apiMessageExampleFileGet");
    }

    @PostMapping(value={"/ApiSpecFile/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecFileGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSpecFileGetService.execute(json), "apiSpecFileGet");
    }

    @GetMapping(value={"/ApiCategory/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiCategoryGet() {
        return this.executeWithWrapper(() -> this.apiCategoryGet.execute(null), "apiCategoryGet");
    }

    @PostMapping(value={"/ApiList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiListGet.execute(json), "apiListGet");
    }

    @PostMapping(value={"/SearchConditionList/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> searchConditionListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.searchConditionListGetService.execute(json), "searchConditionListGet");
    }

    @PostMapping(value={"/AdvanceSearchApiList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> advanceSearchApiListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.advanceSearchApiListGetService.execute(json), "advanceSearchApiListGet");
    }

    @PostMapping(value={"/AdvanceSearchApiListOther/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> advanceSearchApiListOtherGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.advanceSearchApiListGetOtherService.execute(json), "advanceSearchApiListOtherGet");
    }

    @PostMapping(value={"/AdvanceSearchApiCount/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> advanceSearchApiCount(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.advanceSearchApiListGetCountService.execute(json), "advanceSearchApiCount");
    }

    @PostMapping(value={"/ApiStatusList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiStatusListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiStatusListGetService.execute(json), "apiStatusListGet");
    }

    @PostMapping(value={"/ApiListByStatus/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiListByStatusGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiListByStatusGetService.execute(json), "apiListByStatusGet");
    }

    @PostMapping(value={"/ApiReview/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiReviewUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiReviewUpdateService.execute(json), "apiReviewUpdate");
    }

    @PostMapping(value={"/ApiDelete/Delete"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDelete(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDeleteService.execute(json), "apiDelete");
    }

    @PostMapping(value={"/ApiExaminationPassed/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiExaminationPassedUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiExaminationPassedUpdateService.execute(json), "apiExaminationPassedUpdate");
    }

    @PostMapping(value={"/ApiReject/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiRejectUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiRejectUpdateService.execute(json), "apiRejectUpdate");
    }

    @PostMapping(value={"/ApiComfirmed/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiComfirmedUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiComfirmedUpdateService.execute(json), "apiComfirmedUpdate");
    }

    @PostMapping(value={"/ApiSpecRetrieve/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecRetrieveUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSpecRetrieveUpdateService.execute(json), "apiSpecRetrieveUpdate");
    }

    @PostMapping(value={"/ApiDesignAdvanceSearchList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiDesignAdvanceSearchListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDesignAdvanceSearchListGetService.execute(json), "apiDesignAdvanceSearchListGet");
    }

    @PostMapping(value={"/ApiApprovedProcess/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiApprovedProcessGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiApprovedProcessGetService.execute(json), "apiApprovedProcessGet");
    }

    @PostMapping(value={"/ApiDataName/Add"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDataNameAdd(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDataNameAddService.execute(json), "apiDataNameAdd");
    }

    @PostMapping(value={"/ApiDataName/Delete"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDataNameDelete(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDataNameDeleteService.execute(json), "apiDataNameDelete");
    }

    @GetMapping(value={"/DropdownMenu/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> dropdownMenuGet() {
        return this.executeWithWrapper(() -> this.dropdownMenuGetService.execute(null), "dropdownMenuGet");
    }

    @PostMapping(value={"/DuplicateApi/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> duplicateApiGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.duplicateApiGetService.execute(json), "duplicateApiGet");
    }

    @PostMapping(value={"/ApiSpec/Save"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecSaeve(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSpecSaveService.execute(json), "apiSpecSave");
    }

    @PostMapping(value={"/JsonReqImport/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> jsonReqImportGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.jsonReqImportGetService.execute(json), "jsonReqImportGet");
    }

    @PostMapping(value={"/ApiDateNameSearch/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> datanameSearchGet(@RequestBody Map<String, String> param) {
        return this.executeWithWrapper(() -> {
            String dataName = (String)param.get("dataName");
            return this.dataNameSearchService.execute(dataName);
        }, "datanameSearchGet");
    }

    @PostMapping(value={"/ApiDateNameSearch/Reload"})
    public DapCompatibleRespDTO<Map<String, Object>> datanameSearchReload() {
        return this.executeWithWrapper(() -> {
            this.dataNameSearchService.reloadDataNameToTreeSet();
            return new HashMap();
        }, "datanameSearchReload");
    }

    @PostMapping(value={"/StandardDate/Import"})
    public DapCompatibleRespDTO<Map<String, Object>> standardDateImport(@RequestParam(value="file") MultipartFile file) {
        return this.executeWithWrapper(() -> {
            FileDto dwFile = this.convertMultipartFileToDWFile(file);
            return this.standardDataImportService.execute(dwFile);
        }, "standardDateImport");
    }

    @PostMapping(value={"/StandardDate/Export"})
    public void standardDateExport(HttpServletResponse response) {
        this.executeWithWrapper(() -> {
            this.standardDataExportService.execute((OutputStream)response.getOutputStream());
            String time = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd_HH_mm_ss");
            Map responseHeader = ApiMgmtServiceContextHolder.getResponseHeader();
            responseHeader.put("Content-Type", MediaType.APPLICATION_OCTET_STREAM);
            responseHeader.put("Content-Disposition", "attachment;filename=" + time + ".xlsx");
            responseHeader.put("Access-Control-Expose-Headers", "Content-Disposition");
            responseHeader.put("Character-Encoding", "utf-8");
            return null;
        }, "standardDateExport");
    }

    @PostMapping(value={"/ApiVersion/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiVersionGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSearchVersionService.execute(json), "apiVersionGet");
    }

    @PostMapping(value={"/ApiBranch/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiBranchGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiBranchGetService.execute(json), "apiBranchGet");
    }

    @PostMapping(value={"/ApiBuilder/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiBuilderUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiBuilderUpdateService.execute(json), "apiBuilderUpdate");
    }

    @PostMapping(value={"/ApiSpec/BatchSave"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecBatchSave(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSpecBatchSaveService.execute(json), "apiSpecBatchSave");
    }

    @PostMapping(value={"/StandardApiQuery/Export"})
    public DapCompatibleRespDTO<Map<String, Object>> standardApiQueryExport(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.standardApiQueryExportService.execute(json), "standardApiQueryExport");
    }

    @PostMapping(value={"/StandardApiQueryList/Export"})
    public DapCompatibleRespDTO<Map<String, Object>> standardApiQueryListExport(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.standardApiQueryListExportService.execute(json), "standardApiQueryListExport");
    }

    @PostMapping(value={"/dirtyData/query"})
    public DapCompatibleRespDTO<List<Long>> queryDirtyData(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.queryDirtyDataService.queryDirtyData(), "queryDirtyData");
    }

    @PostMapping(value={"/project/queryProjectPage"})
    public DapCompatibleRespDTO<?> queryProjectPage(@RequestBody PageReqCondition<String> condition) {
        return this.executeWithWrapper(() -> {
            try {
                Pagination result = this.projectService.queryProjectPage(condition);
                return Response.buildSuccess((Object)result);
            }
            catch (Exception e) {
                log.error("queryProjectPage exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "queryProjectPage");
    }

    @GetMapping(value={"/project/queryAllProject"})
    public DapCompatibleRespDTO<?> queryAllProject() {
        return this.executeWithWrapper(() -> {
            try {
                List result = this.projectService.queryProject();
                return Response.buildSuccess((Object)result);
            }
            catch (Exception e) {
                log.error("queryAllProject exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "queryAllProject");
    }

    @GetMapping(value={"/project/queryProjectVersion"})
    public DapCompatibleRespDTO<Object> queryProjectVersion(@RequestParam Long projectId) {
        return this.executeWithWrapper(() -> {
            try {
                List result = this.projectService.queryProjectVersion(projectId);
                return Response.buildSuccess((Object)result);
            }
            catch (Exception e) {
                log.error("queryProjectVersion exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "queryProjectVersion");
    }

    @PostMapping(value={"/project/addProject"})
    public DapCompatibleRespDTO<Object> addProject(@RequestBody ProjectDto projectDto) {
        return this.executeWithWrapper(() -> {
            try {
                projectDto.validateFields();
                return Response.buildSuccess((Object)this.projectService.addProject(projectDto));
            }
            catch (Exception e) {
                log.error("addProject exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "addProject");
    }

    @GetMapping(value={"/project/getProjectDetail"})
    public DapCompatibleRespDTO<Object> getProjectDetail(@RequestParam Long projectId) {
        return this.executeWithWrapper(() -> {
            try {
                return Response.buildSuccess((Object)this.projectService.getProjectDetail(projectId));
            }
            catch (Exception e) {
                log.error("getProjectDetail exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "getProjectDetail");
    }

    @GetMapping(value={"/project/deleteProject"})
    public DapCompatibleRespDTO<?> deleteProject(@RequestParam Long projectId) {
        return this.executeWithWrapper(() -> {
            try {
                Boolean res = this.projectService.deleteProject(projectId);
                return Response.buildSuccess((Object)res);
            }
            catch (Exception e) {
                log.error("deleteProject exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "deleteProject");
    }

    @PostMapping(value={"/project/updateProject"})
    public DapCompatibleRespDTO<?> updateProject(@RequestBody ProjectDto projectDto) {
        return this.executeWithWrapper(() -> {
            try {
                Boolean res = this.projectService.updateProject(projectDto);
                return Response.buildSuccess((Object)res);
            }
            catch (Exception e) {
                log.error("updateProject exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "updateProject");
    }

    @PostMapping(value={"/project/apiBindProjectVersion"})
    public DapCompatibleRespDTO<?> apiBindProjectVersion(@RequestBody ApiBindProjectVersionReqDto reqDto) {
        return this.executeWithWrapper(() -> {
            try {
                Boolean res = this.projectService.apiBindProjectVersion(reqDto);
                return Response.buildSuccess((Object)res);
            }
            catch (Exception e) {
                log.error("apiBindProjectVersion exception: " + e.getMessage(), (Throwable)e);
                return Response.buildFail((String)e.getMessage());
            }
        }, "apiBindProjectVersion");
    }

    private <T> DapCompatibleRespDTO<T> executeWithWrapper(ApiCallable<T> callable, String methodName) {
        try {
            T result = callable.execute();
            return DapCompatibleRespDTO.buildSuccess(result);
        }
        catch (Exception e) {
            log.error(methodName + " exception: " + e.getMessage(), (Throwable)e);
            return DapCompatibleRespDTO.buildFail(e.getMessage());
        }
    }

    private FileDto convertMultipartFileToDWFile(MultipartFile file) throws IOException {
        FileDto dwFile = new FileDto();
        dwFile.setFileName(file.getName());
        dwFile.setInputStream(file.getInputStream());
        dwFile.setSize(file.getSize());
        return dwFile;
    }

    @FunctionalInterface
    private static interface ApiCallable<T> {
        public T execute() throws Exception;
    }
}

