package com.digiwin.athena.apimgmt.infra.spring.controller;

import lombok.Data;

import java.io.Serializable;

@Data
public class DapCompatibleRespDTO<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    private Integer status;
    private String statusDescription;
    private T response;


    public static <T> DapCompatibleRespDTO<T> buildSuccess(T data) {
        DapCompatibleRespDTO<T> dapRespDTO = new DapCompatibleRespDTO<>();
        dapRespDTO.setStatus(200);
        dapRespDTO.setResponse(data);
        return dapRespDTO;
    }

    public static <T> DapCompatibleRespDTO<T> buildFail(String message) {
        DapCompatibleRespDTO<T> dapRespDTO = new DapCompatibleRespDTO<>();
        dapRespDTO.setStatus(500);
        dapRespDTO.setStatusDescription(message);
        return dapRespDTO;
    }
}
