package com.digiwin.athena.apimgmt.infra.spring.config;

import com.digiwin.athena.apimgmt.common.json.JacksonJsonSerializer;
import com.digiwin.athena.apimgmt.common.json.JsonSerializer;
import com.digiwin.athena.apimgmt.common.util.JsonUtil;
import com.digiwin.athena.apimgmt.infra.auth.IApiMgmtIdentityService;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtMdcSyncContext;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtServiceContext;
import com.digiwin.athena.apimgmt.infra.file.ApiMgmtFileService;
import com.digiwin.athena.apimgmt.infra.http.ApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtDmcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMailProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.spring.auth.ApiMgmtIamIdentityService;
import com.digiwin.athena.apimgmt.infra.spring.context.ApiMgmtMdcSyncContextSingleNode;
import com.digiwin.athena.apimgmt.infra.spring.context.SpringApiMgmtServiceContext;
import com.digiwin.athena.apimgmt.infra.spring.http.HttpRetryInterceptor;
import com.digiwin.athena.apimgmt.infra.spring.http.RetryProp;
import com.digiwin.athena.apimgmt.infra.spring.http.SpringApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.spring.mybatis.ApiMgmtTableNameHandler;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.infra.util.PathContextUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtFileDmcService;
import com.digiwin.athena.apimgmt.services.ApiMgmtIamVerifyService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.client.RestTemplate;

/**
 * Spring基础设施配置类
 * 配置Spring实现的基础设施组件
 */
@Import(ApiMgmtConfig.Util.class)
public class ApiMgmtConfig {

    @Configuration
    protected static class Sync {
        @Bean
        @ConditionalOnMissingBean
        public IApiMgmtMdcSyncContext apiMgmtMdcSyncContextSingleNode(ApiMgmtProp apiMgmtProp) {
            return new ApiMgmtMdcSyncContextSingleNode(apiMgmtProp);
        }
    }

    @Configuration
    protected static class File {
        @Bean
        @ConditionalOnMissingBean
        public ApiMgmtFileService apiMgmtFileService(ApiMgmtDmcProp apiMgmtDmcProp, ApiMgmtProp prop) {
            return new ApiMgmtFileDmcService(apiMgmtDmcProp, prop);
        }
    }

    @Configuration
    protected static class Auth {
        @Bean
        @ConditionalOnMissingBean
        public IApiMgmtIdentityService apiMgmtIamIdentitySupplier(ApiMgmtIamVerifyService apiMgmtIamVerifyService) {
            return new ApiMgmtIamIdentityService(apiMgmtIamVerifyService);
        }
    }

    @Configuration
    protected static class Mybatis {
        @Bean
        @ConditionalOnMissingBean
        public ApiMgmtTableNameHandler apiMgmtTableNameHandler(ApiMgmtProp prop) {
            return new ApiMgmtTableNameHandler(prop.getSchemaName());
        }
    }

    @Configuration
    protected static class Prop {
        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties("apimgmt")
        public ApiMgmtProp apimgmtProp() {
            return new ApiMgmtProp();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties("apimgmt.dmc")
        public ApiMgmtDmcProp dmcProp() {
            return new ApiMgmtDmcProp();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties("apimgmt.mail")
        public ApiMgmtMailProp mailProp() {
            return new ApiMgmtMailProp();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties("apimgmt.mdc")
        public ApiMgmtMdcProp mdcProp() {
            return new ApiMgmtMdcProp();
        }
    }

    @SuppressWarnings("SpringJavaAutowiredFieldsWarningInspection")
    @Configuration
    protected static class Util implements InitializingBean {
        @Autowired
        @Lazy
        private IApiMgmtIdentityService identitySupplier;
        @Autowired
        @Lazy
        private ApiMgmtHttpClientWrapper httpClientWrapper;
        @Autowired
        @Lazy
        private JsonSerializer jsonSerializer;
        @Autowired
        @Lazy
        private IApiMgmtServiceContext serviceContext;
        @Autowired
        @Lazy
        private ApiMgmtProp prop;

        @Bean
        @ConditionalOnMissingBean
        public JsonSerializer jsonSerializer() {
            return new JacksonJsonSerializer();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties("apimgmt.retry")
        public RetryProp retryProp() {
            return new RetryProp();
        }

        @Bean
        @ConditionalOnMissingBean
        public HttpRetryInterceptor httpRetryInterceptor(RetryProp retryProp) {
            return new HttpRetryInterceptor(retryProp);
        }

        @Bean
        @ConditionalOnMissingBean(name = "retryRestTemplate")
        public RestTemplate retryRestTemplate(RestTemplateBuilder builder, HttpRetryInterceptor retryInterceptor) {
            return builder
                    .additionalInterceptors(retryInterceptor)
                    .build();
        }

        @Bean
        @ConditionalOnMissingBean
        public IApiMgmtServiceContext springServiceContext(IApiMgmtIdentityService IApiMgmtIdentityService) {
            return new SpringApiMgmtServiceContext(IApiMgmtIdentityService);
        }

        @Bean
        @ConditionalOnMissingBean
        public ApiMgmtHttpClientWrapper springHttpClient(@Qualifier("retryRestTemplate") RestTemplate retryRestTemplate) {
            return new SpringApiMgmtHttpClientWrapper(retryRestTemplate);
        }


        @Override
        public void afterPropertiesSet() {
            PathContextUtil.setProp(prop);
            HttpUtil.setHttpClient(httpClientWrapper);
            JsonUtil.setJsonSerializer(jsonSerializer);
            ApiMgmtServiceContextHolder.setServiceContext(serviceContext);
        }
    }



}
