package com.digiwin.athena.apimgmt.infra.spring.context;

import com.digiwin.athena.apimgmt.infra.context.IApiMgmtMdcSyncContext;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import lombok.RequiredArgsConstructor;

import java.util.concurrent.atomic.AtomicLong;

@RequiredArgsConstructor
public class ApiMgmtMdcSyncContextSingleNode implements IApiMgmtMdcSyncContext {

    private final ApiMgmtProp apiMgmtProp;
    private final AtomicLong nextSyncTime = new AtomicLong(0L);

    @Override
    public long getNextSyncTime() {
        long currentTime = System.currentTimeMillis();
        long nextTime = nextSyncTime.get();

        if (nextTime < currentTime) {
            long intervalMillis = apiMgmtProp.getSync().getMdc().getInterval().toMillis();
            long newNextTime = currentTime + intervalMillis;
            if (nextSyncTime.compareAndSet(nextTime, newNextTime)) {
                return nextTime;
            } else {
                return newNextTime;
            }
        }

        return nextTime;
    }
}
