package com.digiwin.athena.apimgmt.infra.spring.controller;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.apimgmt.apiservice.*;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.dto.*;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.model.ProjectVersion;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/restful/standard/apimgmt")
public class ApiMgmtController {

    @Autowired
    private ApiDetailGetService apiDetailGetService;
    @Autowired
    private ApiDetailGetByNameService apiDetailGetByNameService;
    @Autowired
    private ApiSpecFileGetService apiSpecFileGetService;
    @Autowired
    private ApiMessageExampleFileGetService apiMessageExampleFileGetService;
    @Autowired
    private ApiImportCheckService apiImportCheckService;
    @Autowired
    private ApiImportService apiImportService;
    @Autowired
    private ApiCategoryGetService apiCategoryGet;
    @Autowired
    private ApiListGetService apiListGet;
    @Autowired
    private ApiMgmtSearchConditionListGetService searchConditionListGetService;
    @Autowired
    private AdvanceSearchApiListGetService advanceSearchApiListGetService;
    @Autowired
    private ApiStatusListGetService apiStatusListGetService;
    @Autowired
    private ApiListByStatusGetService apiListByStatusGetService;
    @Autowired
    private ApiReviewUpdateService apiReviewUpdateService;
    @Autowired
    private ApiDeleteService apiDeleteService;
    @Autowired
    private ApiExaminationPassedUpdateService apiExaminationPassedUpdateService;
    @Autowired
    private ApiRejectUpdateService apiRejectUpdateService;
    @Autowired
    private ApiComfirmedUpdateService apiComfirmedUpdateService;
    @Autowired
    private ApiSpecRetrieveUpdateService apiSpecRetrieveUpdateService;
    @Autowired
    private ApiDesignAdvanceSearchListGetService apiDesignAdvanceSearchListGetService;
    @Autowired
    private ApiApprovedProcessGetService apiApprovedProcessGetService;
    @Autowired
    private ApiDataNameAddService apiDataNameAddService;
    @Autowired
    private ApiDataNameDeleteService apiDataNameDeleteService;
    @Autowired
    private ApiMgmtDropdownMenuGetService dropdownMenuGetService;
    @Autowired
    private DuplicateApiGetService duplicateApiGetService;
    @Autowired
    private ApiSpecSaveService apiSpecSaveService;
    @Autowired
    private ApiMgmtJsonReqImportGetService jsonReqImportGetService;
    @Autowired
    private DataNameSearchService dataNameSearchService;
    @Autowired
    private ApiMgmtStandardDataImportService standardDataImportService;
    @Autowired
    private ApiMgmtStandardDataExportService standardDataExportService;
    @Autowired
    private ApiSearchVersionService apiSearchVersionService;
    @Autowired
    private ApiBranchGetService apiBranchGetService;
    @Autowired
    private ApiBuilderUpdateService apiBuilderUpdateService;
    @Autowired
    private ApiSpecBatchSaveService apiSpecBatchSaveService;
    @Autowired
    private StandardApiQueryExportService standardApiQueryExportService;
    @Autowired
    private StandardApiQueryListExportService standardApiQueryListExportService;
    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;
    @Autowired
    private AdvanceSearchApiListGetCountService advanceSearchApiListGetCountService;
    @Autowired
    private ApiMgmtQueryDirtyDataService queryDirtyDataService;
    @Autowired
    private ApiMgmtProjectService projectService;

    /**
     * 取得單支API詳細信息
     */
    @PostMapping("/ApiDetail/Get")
    public DapCompatibleRespDTO<Map<String, Object>> apiDetailGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiDetailGetService.execute(json), "apiDetailGet");
    }

    // TODO 添加athena auth包并配置@FuncAuth注解

    /**
     * 取得單支API詳細信息
     */
    @PostMapping("/ApiDetail/getByName")
    public DapCompatibleRespDTO<Map<String, Object>> apiDetailGetByName(@RequestBody String json) {
        return executeWithWrapper(() -> apiDetailGetByNameService.execute(json), "apiDetailGetByName");
    }

    /**
     * API檢查
     */
    @PostMapping("/ApiImport/Check")
    public DapCompatibleRespDTO<Map<String, Object>> apiImportCheck(@RequestParam("file") MultipartFile file) {
        return executeWithWrapper(() -> {
            FileDto dwFile = convertMultipartFileToDWFile(file);
            return apiImportCheckService.execute(dwFile);
        }, "apiImportCheck");
    }

    /**
     * API導入
     */
    @PostMapping("/ApiImport/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiImport(@RequestParam("file") MultipartFile file) {
        return executeWithWrapper(() -> {
            FileDto dwFile = convertMultipartFileToDWFile(file);
            return apiImportService.execute(dwFile);
        }, "apiImport");
    }

    /**
     * 取得API详情規格檔
     */
    @PostMapping("/MessageExampleFile/Get")
    public DapCompatibleRespDTO<Map<String, Object>> apiMessageExampleFileGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiMessageExampleFileGetService.execute(json), "apiMessageExampleFileGet");
    }

    /**
     * 取得API規格檔或範例模板
     */
    @PostMapping("/ApiSpecFile/Get")
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecFileGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiSpecFileGetService.execute(json), "apiSpecFileGet");
    }

    /**
     * 取得信息類別清單
     */
    @GetMapping("/ApiCategory/Get")
    public DapCompatibleRespDTO<ArrayList<?>> apiCategoryGet() {
        return executeWithWrapper(() -> apiCategoryGet.execute(null), "apiCategoryGet");
    }

    /**
     * 取得API清單
     */
    @PostMapping("/ApiList/Get")
    public DapCompatibleRespDTO<ArrayList<?>> apiListGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiListGet.execute(json), "apiListGet");
    }

    /**
     * 取得查詢條件清單
     */
    @PostMapping("/SearchConditionList/Get")
    public DapCompatibleRespDTO<Map<String, Object>> searchConditionListGet(@RequestBody String json) {
        return executeWithWrapper(() -> searchConditionListGetService.execute(json), "searchConditionListGet");
    }

    /**
     * 進階查詢
     */
    @PostMapping("/AdvanceSearchApiList/Get")
    public DapCompatibleRespDTO<ArrayList<?>> advanceSearchApiListGet(@RequestBody String json) {
        return executeWithWrapper(() -> advanceSearchApiListGetService.execute(json), "advanceSearchApiListGet");
    }

    /**
     * 進階查詢
     */
    @PostMapping("/AdvanceSearchApiListOther/Get")
    public DapCompatibleRespDTO<Map<String, Object>> advanceSearchApiListOtherGet(@RequestBody String json) {
        return executeWithWrapper(() -> advanceSearchApiListGetOtherService.execute(json), "advanceSearchApiListOtherGet");
    }

    /**
     * 進階查詢-标准api-个数
     */
    @PostMapping("/AdvanceSearchApiCount/Get")
    public DapCompatibleRespDTO<Map<String, Object>> advanceSearchApiCount(@RequestBody String json) {
        return executeWithWrapper(() -> advanceSearchApiListGetCountService.execute(json), "advanceSearchApiCount");
    }

    /**
     * 取得API狀態清單
     */
    @PostMapping("/ApiStatusList/Get")
    public DapCompatibleRespDTO<ArrayList<?>> apiStatusListGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiStatusListGetService.execute(json), "apiStatusListGet");
    }

    /**
     * 取得API清單(狀態)
     */
    @PostMapping("/ApiListByStatus/Get")
    public DapCompatibleRespDTO<ArrayList<?>> apiListByStatusGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiListByStatusGetService.execute(json), "apiListByStatusGet");
    }

    /**
     * API送審
     */
    @PostMapping("/ApiReview/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiReviewUpdate(@RequestBody String json) {
        return executeWithWrapper(() -> apiReviewUpdateService.execute(json), "apiReviewUpdate");
    }

    /**
     * API刪除
     */
    @PostMapping("/ApiDelete/Delete")
    public DapCompatibleRespDTO<Map<String, Object>> apiDelete(@RequestBody String json) {
        return executeWithWrapper(() -> apiDeleteService.execute(json), "apiDelete");
    }

    /**
     * API審核通過
     */
    @PostMapping("/ApiExaminationPassed/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiExaminationPassedUpdate(@RequestBody String json) {
        return executeWithWrapper(() -> apiExaminationPassedUpdateService.execute(json), "apiExaminationPassedUpdate");
    }

    /**
     * API退回
     */
    @PostMapping("/ApiReject/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiRejectUpdate(@RequestBody String json) {
        return executeWithWrapper(() -> apiRejectUpdateService.execute(json), "apiRejectUpdate");
    }

    /**
     * API定版
     */
    @PostMapping("/ApiComfirmed/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiComfirmedUpdate(@RequestBody String json) {
        return executeWithWrapper(() -> apiComfirmedUpdateService.execute(json), "apiComfirmedUpdate");
    }

    /**
     * API規格取回
     */
    @PostMapping("/ApiSpecRetrieve/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecRetrieveUpdate(@RequestBody String json) {
        return executeWithWrapper(() -> apiSpecRetrieveUpdateService.execute(json), "apiSpecRetrieveUpdate");
    }

    /**
     * API設計進階查詢
     */
    @PostMapping("/ApiDesignAdvanceSearchList/Get")
    public DapCompatibleRespDTO<ArrayList<?>> apiDesignAdvanceSearchListGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiDesignAdvanceSearchListGetService.execute(json), "apiDesignAdvanceSearchListGet");
    }

    /**
     * 查詢API審核歷程
     */
    @PostMapping("/ApiApprovedProcess/Get")
    public DapCompatibleRespDTO<Map<String, Object>> apiApprovedProcessGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiApprovedProcessGetService.execute(json), "apiApprovedProcessGet");
    }

    /**
     * 新增辭彙
     */
    @PostMapping("/ApiDataName/Add")
    public DapCompatibleRespDTO<Map<String, Object>> apiDataNameAdd(@RequestBody String json) {
        return executeWithWrapper(() -> apiDataNameAddService.execute(json), "apiDataNameAdd");
    }

    /**
     * 刪除辭彙
     */
    @PostMapping("/ApiDataName/Delete")
    public DapCompatibleRespDTO<Map<String, Object>> apiDataNameDelete(@RequestBody String json) {
        return executeWithWrapper(() -> apiDataNameDeleteService.execute(json), "apiDataNameDelete");
    }

    /**
     * 取得API規格下拉選項欄位與清單值
     */
    @GetMapping("/DropdownMenu/Get")
    public DapCompatibleRespDTO<Map<String, Object>> dropdownMenuGet() {
        return executeWithWrapper(() -> dropdownMenuGetService.execute(null), "dropdownMenuGet");
    }

    /**
     * 複製API規格
     */
    @PostMapping("/DuplicateApi/Get")
    public DapCompatibleRespDTO<Map<String, Object>> duplicateApiGet(@RequestBody String json) {
        return executeWithWrapper(() -> duplicateApiGetService.execute(json), "duplicateApiGet");
    }

    /**
     * 保存API規格
     */
    @PostMapping("/ApiSpec/Save")
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecSaeve(@RequestBody String json) {
        return executeWithWrapper(() -> apiSpecSaveService.execute(json), "apiSpecSave");
    }

    /**
     * JSON智能識別導入
     */
    @PostMapping("/JsonReqImport/Get")
    public DapCompatibleRespDTO<Map<String, Object>> jsonReqImportGet(@RequestBody String json) {
        return executeWithWrapper(() -> jsonReqImportGetService.execute(json), "jsonReqImportGet");
    }

    /**
     * 詞彙快速查找
     */
    @PostMapping("/ApiDateNameSearch/Get")
    public DapCompatibleRespDTO<Map<String, Object>> datanameSearchGet(@RequestBody Map<String, String> param) {
        return executeWithWrapper(() -> {
            String dataName = param.get("dataName");
            return dataNameSearchService.execute(dataName);
        }, "datanameSearchGet");
    }

    /**
     * 詞彙重新載入
     */
    @PostMapping("/ApiDateNameSearch/Reload")
    public DapCompatibleRespDTO<Map<String, Object>> datanameSearchReload() {
        return executeWithWrapper(() -> {
            dataNameSearchService.reloadDataNameToTreeSet();
            return new HashMap<>();
        }, "datanameSearchReload");
    }

    /**
     * 未审批词典导入
     */
    @PostMapping("/StandardDate/Import")
    public DapCompatibleRespDTO<Map<String, Object>> standardDateImport(@RequestParam("file") MultipartFile file) {
        return executeWithWrapper(() -> {
            FileDto dwFile = convertMultipartFileToDWFile(file);
            return standardDataImportService.execute(dwFile);
        }, "standardDateImport");
    }

    /**
     * 未审批词典导出
     */
    @PostMapping("/StandardDate/Export")
    public void standardDateExport(HttpServletResponse response) {
        executeWithWrapper(() -> {
            standardDataExportService.execute(response.getOutputStream());

            String time = DateUtil.format(LocalDateTime.now(), "yyyy-MM-dd_HH_mm_ss");
            Map<String, Object> responseHeader = ApiMgmtServiceContextHolder.getResponseHeader();
            responseHeader.put("Content-Type", MediaType.APPLICATION_OCTET_STREAM);
            responseHeader.put("Content-Disposition", "attachment;filename=" + time + ".xlsx");
            responseHeader.put("Access-Control-Expose-Headers", "Content-Disposition");
            responseHeader.put("Character-Encoding", "utf-8");

            return null;
        }, "standardDateExport");
    }

    /**
     * 获取新增|进阶版本号
     */
    @PostMapping("/ApiVersion/Get")
    public DapCompatibleRespDTO<Map<String, Object>> apiVersionGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiSearchVersionService.execute(json), "apiVersionGet");
    }

    /**
     * 获取新增的分支号
     */
    @PostMapping("/ApiBranch/Get")
    public DapCompatibleRespDTO<Map<String, Object>> apiBranchGet(@RequestBody String json) {
        return executeWithWrapper(() -> apiBranchGetService.execute(json), "apiBranchGet");
    }

    /**
     * 更新API的创建人信息
     */
    @PostMapping("/ApiBuilder/Update")
    public DapCompatibleRespDTO<Map<String, Object>> apiBuilderUpdate(@RequestBody String json) {
        return executeWithWrapper(() -> apiBuilderUpdateService.execute(json), "apiBuilderUpdate");
    }

    /**
     * 批量创建API并送审
     */
    @PostMapping("/ApiSpec/BatchSave")
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecBatchSave(@RequestBody String json) {
        return executeWithWrapper(() -> apiSpecBatchSaveService.execute(json), "apiSpecBatchSave");
    }

    /**
     * 标准api查询导出规格
     */
    @PostMapping("/StandardApiQuery/Export")
    public DapCompatibleRespDTO<Map<String, Object>> standardApiQueryExport(@RequestBody String json) {
        return executeWithWrapper(() -> standardApiQueryExportService.execute(json), "standardApiQueryExport");
    }

    /**
     * 标准api查询导出列表
     */
    @PostMapping("/StandardApiQueryList/Export")
    public DapCompatibleRespDTO<Map<String, Object>> standardApiQueryListExport(@RequestBody String json) {
        return executeWithWrapper(() -> standardApiQueryListExportService.execute(json), "standardApiQueryListExport");
    }

    /**
     * api脏数据查询
     */
    @PostMapping("/dirtyData/query")
    public DapCompatibleRespDTO<List<Long>> queryDirtyData(@RequestBody String json) {
        return executeWithWrapper(() -> queryDirtyDataService.queryDirtyData(), "queryDirtyData");
    }

    /**
     * 分页查询项目
     */
    @PostMapping("/project/queryProjectPage")
    public DapCompatibleRespDTO<?> queryProjectPage(@RequestBody PageReqCondition<String> condition) {
        return executeWithWrapper(() -> {
            try {
                Pagination<ProjectDto> result = projectService.queryProjectPage(condition);
                return Response.buildSuccess(result);
            } catch (Exception e) {
                log.error("queryProjectPage exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "queryProjectPage");
    }

    /**
     * 查询所有项目
     */
    @GetMapping("/project/queryAllProject")
    public DapCompatibleRespDTO<?> queryAllProject() {
        return executeWithWrapper(() -> {
            try {
                List<ProjectDto> result = projectService.queryProject();
                return Response.buildSuccess(result);
            } catch (Exception e) {
                log.error("queryAllProject exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "queryAllProject");
    }

    /**
     * 查询项目下的版本
     */
    @GetMapping("/project/queryProjectVersion")
    public DapCompatibleRespDTO<Object> queryProjectVersion(@RequestParam Long projectId) {
        return executeWithWrapper(() -> {
            try {
                List<ProjectVersion> result = projectService.queryProjectVersion(projectId);
                return Response.buildSuccess(result);
            } catch (Exception e) {
                log.error("queryProjectVersion exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "queryProjectVersion");
    }

    /**
     * 新增项目
     */
    @PostMapping("/project/addProject")
    public DapCompatibleRespDTO<Object> addProject(@RequestBody ProjectDto projectDto) {
        return executeWithWrapper(() -> {
            try {
                projectDto.validateFields();
                return Response.buildSuccess(projectService.addProject(projectDto));
            } catch (Exception e) {
                log.error("addProject exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "addProject");
    }

    /**
     * 获取项目详情
     */
    @GetMapping("/project/getProjectDetail")
    public DapCompatibleRespDTO<Object> getProjectDetail(@RequestParam Long projectId) {
        return executeWithWrapper(() -> {
            try {
                return Response.buildSuccess(projectService.getProjectDetail(projectId));
            } catch (Exception e) {
                log.error("getProjectDetail exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "getProjectDetail");
    }

    /**
     * 删除项目
     */
    @GetMapping("/project/deleteProject")
    public DapCompatibleRespDTO<?> deleteProject(@RequestParam Long projectId) {
        return executeWithWrapper(() -> {
            try {
                Boolean res = projectService.deleteProject(projectId);
                return Response.buildSuccess(res);
            } catch (Exception e) {
                log.error("deleteProject exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "deleteProject");
    }

    /**
     * 更新项目
     */
    @PostMapping("/project/updateProject")
    public DapCompatibleRespDTO<?> updateProject(@RequestBody ProjectDto projectDto) {
        return executeWithWrapper(() -> {
            try {
                Boolean res = projectService.updateProject(projectDto);
                return Response.buildSuccess(res);
            } catch (Exception e) {
                log.error("updateProject exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "updateProject");
    }

    /**
     * API绑定项目版本
     */
    @PostMapping("/project/apiBindProjectVersion")
    public DapCompatibleRespDTO<?> apiBindProjectVersion(@RequestBody ApiBindProjectVersionReqDto reqDto) {
        return executeWithWrapper(() -> {
            try {
                Boolean res = projectService.apiBindProjectVersion(reqDto);
                return Response.buildSuccess(res);
            } catch (Exception e) {
                log.error("apiBindProjectVersion exception: " + e.getMessage(), e);
                return Response.buildFail(e.getMessage());
            }
        }, "apiBindProjectVersion");
    }

    private <T> DapCompatibleRespDTO<T> executeWithWrapper(ApiCallable<T> callable, String methodName) {
        try {
            T result = callable.execute();
            return DapCompatibleRespDTO.buildSuccess(result);
        } catch (Exception e) {
            log.error(methodName + " exception: " + e.getMessage(), e);
            return DapCompatibleRespDTO.buildFail(e.getMessage());
        }
    }

    @FunctionalInterface
    private interface ApiCallable<T> {
        T execute() throws Exception;
    }

    private FileDto convertMultipartFileToDWFile(MultipartFile file) throws IOException {
        FileDto dwFile = new FileDto();
        dwFile.setFileName(file.getOriginalFilename());
        dwFile.setInputStream(file.getInputStream());
        dwFile.setSize(file.getSize());
        return dwFile;
    }
}
