package com.digiwin.athena.apimgmt.infra.spring.context;

import com.digiwin.athena.apimgmt.infra.context.IApiMgmtMdcSyncContext;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import lombok.RequiredArgsConstructor;

import java.util.concurrent.atomic.AtomicLong;

@RequiredArgsConstructor
public class DefaultApiMgmtMdcSyncContext implements IApiMgmtMdcSyncContext {

    private final ApiMgmtProp apiMgmtProp;
    private final AtomicLong nextSyncTime = new AtomicLong(0L);

    @Override
    public long getNextSyncTime() {
        long currentTime = System.currentTimeMillis();
        long nextTime = getNextTime();

        if (nextTime <= currentTime) {
            long intervalMillis = apiMgmtProp.getSync().getMdc().getInterval().toMillis();
            long newNextTime = currentTime + intervalMillis;
            if (setNextTime(nextTime, newNextTime)) {
                return nextTime;
            } else {
                return newNextTime;
            }
        }

        return nextTime;
    }

    protected boolean setNextTime(long beforeNextTime, long newNextTime) {
        return nextSyncTime.compareAndSet(beforeNextTime, newNextTime);
    }

    protected long getNextTime() {
        return nextSyncTime.get();
    }
}
