/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.config;

import com.digiwin.athena.apimgmt.common.json.JacksonJsonSerializer;
import com.digiwin.athena.apimgmt.common.json.JsonSerializer;
import com.digiwin.athena.apimgmt.common.util.JsonUtil;
import com.digiwin.athena.apimgmt.infra.auth.IApiMgmtIdentityService;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtMdcSyncContext;
import com.digiwin.athena.apimgmt.infra.context.IApiMgmtServiceContext;
import com.digiwin.athena.apimgmt.infra.file.ApiMgmtFileService;
import com.digiwin.athena.apimgmt.infra.http.ApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtDmcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMailProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtMdcProp;
import com.digiwin.athena.apimgmt.infra.prop.ApiMgmtProp;
import com.digiwin.athena.apimgmt.infra.spring.auth.ApiMgmtIamIdentityService;
import com.digiwin.athena.apimgmt.infra.spring.context.DefaultApiMgmtMdcSyncContext;
import com.digiwin.athena.apimgmt.infra.spring.context.SpringApiMgmtServiceContext;
import com.digiwin.athena.apimgmt.infra.spring.http.HttpRetryInterceptor;
import com.digiwin.athena.apimgmt.infra.spring.http.RetryProp;
import com.digiwin.athena.apimgmt.infra.spring.http.SpringApiMgmtHttpClientWrapper;
import com.digiwin.athena.apimgmt.infra.spring.mybatis.ApiMgmtTableNameHandler;
import com.digiwin.athena.apimgmt.infra.util.HttpUtil;
import com.digiwin.athena.apimgmt.infra.util.PathContextUtil;
import com.digiwin.athena.apimgmt.services.ApiMgmtFileDmcService;
import com.digiwin.athena.apimgmt.services.ApiMgmtIamVerifyService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Import(value={Util.class})
public class ApiMgmtConfig {

    @Configuration
    protected static class Util
    implements InitializingBean {
        @Autowired
        @Lazy
        private IApiMgmtIdentityService identitySupplier;
        @Autowired
        @Lazy
        private ApiMgmtHttpClientWrapper httpClientWrapper;
        @Autowired
        @Lazy
        private JsonSerializer jsonSerializer;
        @Autowired
        @Lazy
        private IApiMgmtServiceContext serviceContext;
        @Autowired
        @Lazy
        private ApiMgmtProp prop;

        protected Util() {
        }

        @Bean
        @ConditionalOnMissingBean
        public JsonSerializer jsonSerializer() {
            return new JacksonJsonSerializer();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="apimgmt.retry")
        public RetryProp retryProp() {
            return new RetryProp();
        }

        @Bean
        @ConditionalOnMissingBean
        public HttpRetryInterceptor httpRetryInterceptor(RetryProp retryProp) {
            return new HttpRetryInterceptor(retryProp);
        }

        @Bean
        @ConditionalOnMissingBean(name={"retryRestTemplate"})
        public RestTemplate retryRestTemplate(RestTemplateBuilder builder, HttpRetryInterceptor retryInterceptor) {
            return builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{retryInterceptor}).build();
        }

        @Bean
        @ConditionalOnMissingBean
        public IApiMgmtServiceContext springServiceContext(IApiMgmtIdentityService IApiMgmtIdentityService2) {
            return new SpringApiMgmtServiceContext(IApiMgmtIdentityService2);
        }

        @Bean
        @ConditionalOnMissingBean
        public ApiMgmtHttpClientWrapper springHttpClient(@Qualifier(value="retryRestTemplate") RestTemplate retryRestTemplate) {
            return new SpringApiMgmtHttpClientWrapper(retryRestTemplate);
        }

        public void afterPropertiesSet() {
            PathContextUtil.setProp((ApiMgmtProp)this.prop);
            HttpUtil.setHttpClient((ApiMgmtHttpClientWrapper)this.httpClientWrapper);
            JsonUtil.setJsonSerializer((JsonSerializer)this.jsonSerializer);
            ApiMgmtServiceContextHolder.setServiceContext((IApiMgmtServiceContext)this.serviceContext);
        }
    }

    @Configuration
    protected static class Prop {
        protected Prop() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="apimgmt")
        public ApiMgmtProp apimgmtProp() {
            return new ApiMgmtProp();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="apimgmt.dmc")
        public ApiMgmtDmcProp dmcProp() {
            return new ApiMgmtDmcProp();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="apimgmt.mail")
        public ApiMgmtMailProp mailProp() {
            return new ApiMgmtMailProp();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(value="apimgmt.mdc")
        public ApiMgmtMdcProp mdcProp() {
            return new ApiMgmtMdcProp();
        }
    }

    @Configuration
    protected static class Mybatis {
        protected Mybatis() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ApiMgmtTableNameHandler apiMgmtTableNameHandler(ApiMgmtProp prop) {
            return new ApiMgmtTableNameHandler(prop.getSchemaName());
        }
    }

    @Configuration
    protected static class Auth {
        protected Auth() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IApiMgmtIdentityService apiMgmtIamIdentitySupplier(ApiMgmtIamVerifyService apiMgmtIamVerifyService) {
            return new ApiMgmtIamIdentityService(apiMgmtIamVerifyService);
        }
    }

    @Configuration
    protected static class File {
        protected File() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ApiMgmtFileService apiMgmtFileService(ApiMgmtDmcProp apiMgmtDmcProp, ApiMgmtProp prop) {
            return new ApiMgmtFileDmcService(apiMgmtDmcProp, prop);
        }
    }

    @Configuration
    protected static class Sync {
        protected Sync() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IApiMgmtMdcSyncContext apiMgmtMdcSyncContextSingleNode(ApiMgmtProp apiMgmtProp) {
            return new DefaultApiMgmtMdcSyncContext(apiMgmtProp);
        }
    }
}

