/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.spring.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.apimgmt.ApiMgmtApplicationParameter;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetCountService;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetOtherService;
import com.digiwin.athena.apimgmt.apiservice.AdvanceSearchApiListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiApprovedProcessGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiBranchGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiBuilderUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiCategoryGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiComfirmedUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiDataNameAddService;
import com.digiwin.athena.apimgmt.apiservice.ApiDataNameDeleteService;
import com.digiwin.athena.apimgmt.apiservice.ApiDeleteService;
import com.digiwin.athena.apimgmt.apiservice.ApiDesignAdvanceSearchListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiDetailGetByNameService;
import com.digiwin.athena.apimgmt.apiservice.ApiDetailGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiExaminationPassedUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiImportCheckService;
import com.digiwin.athena.apimgmt.apiservice.ApiImportService;
import com.digiwin.athena.apimgmt.apiservice.ApiListByStatusGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMessageExampleFileGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtDropdownMenuGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtJsonReqImportGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtProjectService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtQueryDirtyDataService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtSearchConditionListGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtStandardDataExportService;
import com.digiwin.athena.apimgmt.apiservice.ApiMgmtStandardDataImportService;
import com.digiwin.athena.apimgmt.apiservice.ApiParamTextService;
import com.digiwin.athena.apimgmt.apiservice.ApiRejectUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiReviewUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiSearchVersionService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecBatchSaveService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecFileGetService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecRetrieveUpdateService;
import com.digiwin.athena.apimgmt.apiservice.ApiSpecSaveService;
import com.digiwin.athena.apimgmt.apiservice.ApiStatusListGetService;
import com.digiwin.athena.apimgmt.apiservice.DataNameSearchService;
import com.digiwin.athena.apimgmt.apiservice.DuplicateApiGetService;
import com.digiwin.athena.apimgmt.apiservice.StandardApiQueryExportService;
import com.digiwin.athena.apimgmt.apiservice.StandardApiQueryListExportService;
import com.digiwin.athena.apimgmt.cache.GuavaLocalCache;
import com.digiwin.athena.apimgmt.common.model.dto.FileDto;
import com.digiwin.athena.apimgmt.dto.ApiBindProjectVersionReqDto;
import com.digiwin.athena.apimgmt.dto.ApiParamTextResDto;
import com.digiwin.athena.apimgmt.dto.PageReqCondition;
import com.digiwin.athena.apimgmt.dto.ProjectDto;
import com.digiwin.athena.apimgmt.dto.Response;
import com.digiwin.athena.apimgmt.infra.context.ApiMgmtServiceContextHolder;
import com.digiwin.athena.apimgmt.infra.spring.controller.DapCompatibleRespDTO;
import com.digiwin.athena.apimgmt.service.util.DevelopmentPlatformServiceUtil;
import com.digiwin.athena.auth.annotation.FuncAuth;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/restful/standard/apimgmt"})
public class ApiMgmtController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMgmtController.class);
    private static final Lock LOCK = new ReentrantLock(true);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    @Lazy
    private ApiMgmtController proxyThis;
    @Autowired
    private ApiDetailGetService apiDetailGetService;
    @Autowired
    private ApiDetailGetByNameService apiDetailGetByNameService;
    @Autowired
    private ApiSpecFileGetService apiSpecFileGetService;
    @Autowired
    private ApiMessageExampleFileGetService apiMessageExampleFileGetService;
    @Autowired
    private ApiImportCheckService apiImportCheckService;
    @Autowired
    private ApiImportService apiImportService;
    @Autowired
    private ApiCategoryGetService apiCategoryGet;
    @Autowired
    private ApiListGetService apiListGet;
    @Autowired
    private ApiMgmtSearchConditionListGetService searchConditionListGetService;
    @Autowired
    private AdvanceSearchApiListGetService advanceSearchApiListGetService;
    @Autowired
    private ApiStatusListGetService apiStatusListGetService;
    @Autowired
    private ApiListByStatusGetService apiListByStatusGetService;
    @Autowired
    private ApiReviewUpdateService apiReviewUpdateService;
    @Autowired
    private ApiDeleteService apiDeleteService;
    @Autowired
    private ApiExaminationPassedUpdateService apiExaminationPassedUpdateService;
    @Autowired
    private ApiRejectUpdateService apiRejectUpdateService;
    @Autowired
    private ApiComfirmedUpdateService apiComfirmedUpdateService;
    @Autowired
    private ApiSpecRetrieveUpdateService apiSpecRetrieveUpdateService;
    @Autowired
    private ApiDesignAdvanceSearchListGetService apiDesignAdvanceSearchListGetService;
    @Autowired
    private ApiApprovedProcessGetService apiApprovedProcessGetService;
    @Autowired
    private ApiDataNameAddService apiDataNameAddService;
    @Autowired
    private ApiDataNameDeleteService apiDataNameDeleteService;
    @Autowired
    private ApiMgmtDropdownMenuGetService dropdownMenuGetService;
    @Autowired
    private DuplicateApiGetService duplicateApiGetService;
    @Autowired
    private ApiSpecSaveService apiSpecSaveService;
    @Autowired
    private ApiMgmtJsonReqImportGetService jsonReqImportGetService;
    @Autowired
    private DataNameSearchService dataNameSearchService;
    @Autowired
    private ApiMgmtStandardDataImportService standardDataImportService;
    @Autowired
    private ApiMgmtStandardDataExportService standardDataExportService;
    @Autowired
    private ApiSearchVersionService apiSearchVersionService;
    @Autowired
    private ApiBranchGetService apiBranchGetService;
    @Autowired
    private ApiBuilderUpdateService apiBuilderUpdateService;
    @Autowired
    private ApiSpecBatchSaveService apiSpecBatchSaveService;
    @Autowired
    private StandardApiQueryExportService standardApiQueryExportService;
    @Autowired
    private StandardApiQueryListExportService standardApiQueryListExportService;
    @Autowired
    private AdvanceSearchApiListGetOtherService advanceSearchApiListGetOtherService;
    @Autowired
    private AdvanceSearchApiListGetCountService advanceSearchApiListGetCountService;
    @Autowired
    private ApiMgmtQueryDirtyDataService queryDirtyDataService;
    @Autowired
    private ApiMgmtProjectService projectService;
    @Autowired
    private GuavaLocalCache guavaLocalCache;
    @Autowired
    private ApiParamTextService apiParamTextService;

    @PostMapping(value={"/ApiDetail/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDetailGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDetailGetService.execute(json));
    }

    @PostMapping(value={"/ApiDetail/getByName"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDetailGetByName(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDetailGetByNameService.execute(json));
    }

    @PostMapping(value={"/ApiImport/Check"})
    public DapCompatibleRespDTO<Map<String, Object>> apiImportCheck(@RequestParam(value="file") MultipartFile file) {
        ApiCallable<Map> func = () -> {
            FileDto dwFile = this.convertMultipartFileToDWFile(file);
            return this.apiImportCheckService.execute(dwFile);
        };
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiImport/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiImport(@RequestParam(value="file") MultipartFile file) {
        ApiCallable<Map> func = () -> {
            FileDto dwFile = this.convertMultipartFileToDWFile(file);
            return this.apiImportService.execute(dwFile);
        };
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/MessageExampleFile/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiMessageExampleFileGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiMessageExampleFileGetService.execute(json));
    }

    @PostMapping(value={"/ApiSpecFile/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecFileGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSpecFileGetService.execute(json));
    }

    @GetMapping(value={"/ApiCategory/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiCategoryGet() {
        return this.executeWithWrapper(() -> this.apiCategoryGet.execute(null));
    }

    @PostMapping(value={"/ApiList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiListGet.execute(json));
    }

    @PostMapping(value={"/SearchConditionList/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> searchConditionListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.searchConditionListGetService.execute(json));
    }

    @PostMapping(value={"/AdvanceSearchApiList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> advanceSearchApiListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.advanceSearchApiListGetService.execute(json));
    }

    @PostMapping(value={"/AdvanceSearchApiListOther/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> advanceSearchApiListOtherGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.advanceSearchApiListGetOtherService.execute(json));
    }

    @PostMapping(value={"/AdvanceSearchApiCount/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> advanceSearchApiCount(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.advanceSearchApiListGetCountService.execute(json));
    }

    @PostMapping(value={"/ApiStatusList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiStatusListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiStatusListGetService.execute(json));
    }

    @PostMapping(value={"/ApiListByStatus/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiListByStatusGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiListByStatusGetService.execute(json));
    }

    @PostMapping(value={"/ApiReview/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiReviewUpdate(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiReviewUpdateService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiDelete/Delete"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDelete(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiDeleteService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiExaminationPassed/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiExaminationPassedUpdate(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiExaminationPassedUpdateService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiReject/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiRejectUpdate(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiRejectUpdateService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiComfirmed/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiComfirmedUpdate(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiComfirmedUpdateService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiSpecRetrieve/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecRetrieveUpdate(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiSpecRetrieveUpdateService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/ApiDesignAdvanceSearchList/Get"})
    public DapCompatibleRespDTO<ArrayList<?>> apiDesignAdvanceSearchListGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDesignAdvanceSearchListGetService.execute(json));
    }

    @PostMapping(value={"/ApiApprovedProcess/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiApprovedProcessGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiApprovedProcessGetService.execute(json));
    }

    @PostMapping(value={"/ApiDataName/Add"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDataNameAdd(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDataNameAddService.execute(json));
    }

    @PostMapping(value={"/ApiDataName/Delete"})
    public DapCompatibleRespDTO<Map<String, Object>> apiDataNameDelete(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiDataNameDeleteService.execute(json));
    }

    @GetMapping(value={"/DropdownMenu/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> dropdownMenuGet() {
        return this.executeWithWrapper(() -> this.dropdownMenuGetService.execute(null));
    }

    @PostMapping(value={"/DuplicateApi/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> duplicateApiGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.duplicateApiGetService.execute(json));
    }

    @PostMapping(value={"/ApiSpec/Save"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecSaeve(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiSpecSaveService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/JsonReqImport/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> jsonReqImportGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.jsonReqImportGetService.execute(json));
    }

    @PostMapping(value={"/ApiDateNameSearch/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> datanameSearchGet(@RequestBody Map<String, String> param) {
        return this.executeWithWrapper(() -> {
            String dataName = (String)param.get("dataName");
            return this.dataNameSearchService.execute(dataName);
        });
    }

    @PostMapping(value={"/ApiDateNameSearch/Reload"})
    public DapCompatibleRespDTO<Map<String, Object>> datanameSearchReload() {
        return this.executeWithWrapper(() -> {
            this.dataNameSearchService.reloadDataNameToTreeSet();
            return new HashMap();
        });
    }

    @PostMapping(value={"/StandardDate/Import"})
    public DapCompatibleRespDTO<Map<String, Object>> standardDateImport(@RequestParam(value="file") MultipartFile file) {
        return this.executeWithWrapper(() -> {
            FileDto dwFile = this.convertMultipartFileToDWFile(file);
            return this.standardDataImportService.execute(dwFile);
        });
    }

    @PostMapping(value={"/StandardDate/Export"})
    public void standardDateExport(HttpServletResponse response) {
        this.executeWithWrapper(() -> {
            this.standardDataExportService.execute((OutputStream)response.getOutputStream());
            String time = DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd_HH_mm_ss");
            Map responseHeader = ApiMgmtServiceContextHolder.getResponseHeader();
            responseHeader.put("Content-Type", MediaType.APPLICATION_OCTET_STREAM);
            responseHeader.put("Content-Disposition", "attachment;filename=" + time + ".xlsx");
            responseHeader.put("Access-Control-Expose-Headers", "Content-Disposition");
            responseHeader.put("Character-Encoding", "utf-8");
            return null;
        });
    }

    @PostMapping(value={"/ApiVersion/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiVersionGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiSearchVersionService.execute(json));
    }

    @PostMapping(value={"/ApiBranch/Get"})
    public DapCompatibleRespDTO<Map<String, Object>> apiBranchGet(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiBranchGetService.execute(json));
    }

    @PostMapping(value={"/ApiBuilder/Update"})
    public DapCompatibleRespDTO<Map<String, Object>> apiBuilderUpdate(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.apiBuilderUpdateService.execute(json));
    }

    @PostMapping(value={"/ApiSpec/BatchSave"})
    public DapCompatibleRespDTO<Map<String, Object>> apiSpecBatchSave(@RequestBody String json) {
        ApiCallable<Map> func = () -> this.apiSpecBatchSaveService.execute(json);
        if (this.authJudge().booleanValue()) {
            return this.executeWithWrapper(func);
        }
        return this.proxyThis.executeWithAuthWrapper(func);
    }

    @PostMapping(value={"/StandardApiQuery/Export"})
    public DapCompatibleRespDTO<Map<String, Object>> standardApiQueryExport(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.standardApiQueryExportService.execute(json));
    }

    @PostMapping(value={"/StandardApiQueryList/Export"})
    public DapCompatibleRespDTO<Map<String, Object>> standardApiQueryListExport(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.standardApiQueryListExportService.execute(json));
    }

    @PostMapping(value={"/dirtyData/query"})
    public DapCompatibleRespDTO<List<Long>> queryDirtyData(@RequestBody String json) {
        return this.executeWithWrapper(() -> this.queryDirtyDataService.queryDirtyData());
    }

    @PostMapping(value={"/project/queryProjectPage"})
    public DapCompatibleRespDTO<?> queryProjectPage(@RequestBody PageReqCondition<String> condition) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.queryProjectPage(condition));
        return this.executeWithWrapper(func);
    }

    @GetMapping(value={"/project/queryAllProject"})
    public DapCompatibleRespDTO<?> queryAllProject() {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.queryProject());
        return this.executeWithWrapper(func);
    }

    @GetMapping(value={"/project/queryProjectVersion"})
    public DapCompatibleRespDTO<?> queryProjectVersion(@RequestParam Long projectId) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.queryProjectVersion(projectId));
        return this.executeWithWrapper(func);
    }

    @PostMapping(value={"/project/addProject"})
    public DapCompatibleRespDTO<?> addProject(@RequestBody ProjectDto projectDto) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> {
            projectDto.validateFields();
            return this.projectService.addProject(projectDto);
        });
        return this.executeWithWrapper(func);
    }

    @GetMapping(value={"/project/getProjectDetail"})
    public DapCompatibleRespDTO<?> getProjectDetail(@RequestParam Long projectId) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.getProjectDetail(projectId));
        return this.executeWithWrapper(func);
    }

    @GetMapping(value={"/project/deleteProject"})
    public DapCompatibleRespDTO<?> deleteProject(@RequestParam Long projectId) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.deleteProject(projectId));
        return this.executeWithWrapper(func);
    }

    @PostMapping(value={"/project/updateProject"})
    public DapCompatibleRespDTO<?> updateProject(@RequestBody ProjectDto projectDto) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.updateProject(projectDto));
        return this.executeWithWrapper(func);
    }

    @PostMapping(value={"/project/apiBindProjectVersion"})
    public DapCompatibleRespDTO<?> apiBindProjectVersion(@RequestBody ApiBindProjectVersionReqDto reqDto) {
        ApiCallable<Response<Object>> func = this.wrapToResponseType(() -> this.projectService.apiBindProjectVersion(reqDto));
        return this.executeWithWrapper(func);
    }

    @GetMapping(value={"/api/getApiParamText"})
    public DapCompatibleRespDTO<?> getApiParamText(Long projectId) {
        ApiCallable<Response<ApiParamTextResDto>> func = this.wrapToResponseType(() -> this.apiParamTextService.getApiParamText(projectId));
        return this.executeWithWrapper(func);
    }

    @PostMapping(value={"/api/generateApiParamText"})
    public DapCompatibleRespDTO<?> generateApiParamText(@RequestBody String json) {
        ApiCallable<Response<String>> func = this.wrapToResponseType(() -> this.apiParamTextService.generateApiParamText(json));
        return this.executeWithWrapper(func);
    }

    protected <T> ApiCallable<Response<T>> wrapToResponseType(ApiCallable<T> apiCallable) {
        return () -> {
            try {
                return Response.buildSuccess(apiCallable.execute());
            }
            catch (Exception e) {
                log.error("request uri:{}, exception: {}", new Object[]{this.request.getRequestURI(), e.getMessage(), e});
                return Response.buildFail((String)e.getMessage());
            }
        };
    }

    protected <T> DapCompatibleRespDTO<T> executeWithWrapper(ApiCallable<T> callable) {
        try {
            T result = callable.execute();
            return DapCompatibleRespDTO.buildSuccess(result);
        }
        catch (Exception e) {
            log.error("request uri:{}, exception: {}", new Object[]{this.request.getRequestURI(), e.getMessage(), e});
            return DapCompatibleRespDTO.buildFail(e.getMessage());
        }
    }

    @FuncAuth(resourceType="integration", actions={":*"}, resourceId="Var:$tenantId")
    public <T> DapCompatibleRespDTO<T> executeWithAuthWrapper(ApiCallable<T> callable) {
        return this.executeWithWrapper(callable);
    }

    private Boolean authJudge() {
        String tToken = ApiMgmtServiceContextHolder.getToken();
        String tUserId = ApiMgmtServiceContextHolder.getUserId();
        List ids = (List)this.guavaLocalCache.getCache().getIfPresent((Object)"authUserWhiteList");
        if (CollUtil.isEmpty((Collection)ids)) {
            LOCK.lock();
            try {
                ids = (List)this.guavaLocalCache.getCache().getIfPresent((Object)"authUserWhiteList");
                if (CollUtil.isEmpty((Collection)ids) && StrUtil.isNotEmpty((CharSequence)ApiMgmtApplicationParameter.SYNC_DEV_URL)) {
                    ids = DevelopmentPlatformServiceUtil.getWithAuthList((String)tToken, (String)"apimgmtAuthUserWhiteList");
                    this.guavaLocalCache.getCache().put((Object)"authUserWhiteList", (Object)ids);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                LOCK.unlock();
            }
        }
        if (CollUtil.isNotEmpty((Collection)ids)) {
            return ids.contains(tUserId);
        }
        return false;
    }

    private FileDto convertMultipartFileToDWFile(MultipartFile file) throws IOException {
        FileDto dwFile = new FileDto();
        dwFile.setFileName(file.getOriginalFilename());
        dwFile.setInputStream(file.getInputStream());
        dwFile.setSize(file.getSize());
        return dwFile;
    }

    @FunctionalInterface
    public static interface ApiCallable<T> {
        public T execute() throws Exception;
    }
}

