package com.digiwin.athena.apimgmt.infra.spring.mybatis;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.digiwin.athena.apimgmt.ApiMgmtPackage;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ApiMgmtTableNameHandler implements TableNameHandler {
    public static final String APIMGMT_PACKAGE = ClassUtil.getPackage(ApiMgmtPackage.class);

    private final String schemaPrefix;

    public ApiMgmtTableNameHandler(String schemaName) {
        this.schemaPrefix = StrUtil.isNotBlank(schemaName) ? schemaName + "." : null;
    }

    @Override
    public String dynamicTableName(String sql, String tableName) {
        if (schemaPrefix == null) {
            return tableName;
        }

        TableInfo tableInfo = TableInfoHelper.getTableInfo(tableName);
        if (tableInfo == null) {
            return tableName;
        }

        Class<?> entityType = tableInfo.getEntityType();
        if (entityType == null) {
            return tableName;
        }

        if (entityType.getName().startsWith(APIMGMT_PACKAGE)) {
            return schemaPrefix + tableName;
        }

        return tableName;
    }
}
