package com.digiwin.athena.apimgmt.infra.prop;

import cn.hutool.core.util.StrUtil;
import lombok.Data;

@Data
public class ApiMgmtProp {
    private Val devPlatform = new Val();

    /**
     * 开启权限验证,通过类型添加区分pass区还是test区
     */
    private boolean envType = false;

    private String iamUrl;
    private String iamToken;
    private Integer iamSocketTimeout = 1500;

    private String integrationUserId;
    private String integrationPwd;

    private String translateCenterUrl;

    private String eaiUrl;

    private String backendPath;

    private String schemaName;

    public String getBackendPath() {
        if (StrUtil.isNotBlank(backendPath)) {
            return backendPath;
        }

        return System.getProperty("user.dir");
    }

    @Data
    public static class Val {
        private String url;
    }
}

