package com.digiwin.athena.apimgmt.infra.auth;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.function.Function;
import java.util.function.Supplier;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ApiMgmtIdentity {
    private String tenantId;
    private String tenantName;
    private String userId;
    private String userName;
    private String teamId;
    private String teamType;

    private boolean teamIdRetrieved = false;
    /**
     * 延迟teamId请求发送
     */
    private transient Supplier<String> teamIdSupplier;
    private transient Function<ApiMgmtIdentity, String> teamTypeSupplier;


    public String getTeamId() {
        if (teamIdRetrieved) {
            return teamId;
        }

        if (teamIdSupplier != null) {
            teamId = teamIdSupplier.get();
        }

        return teamId;
    }

    public String getTeamType() {
        if (teamType != null) {
            return teamType;
        }

        if (teamTypeSupplier != null) {
            teamType = teamTypeSupplier.apply(this);
        }

        return teamType;
    }
}
