/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.apimgmt.infra.http;

import cn.hutool.core.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import lombok.Generated;

public class MultipartFile {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final String name;
    private final InputStream is;
    private final String contentType;
    private final String fileName;
    private final long size;

    public MultipartFile(String name, File file) {
        this(name, IoUtil.toStream((File)file), file.length(), APPLICATION_OCTET_STREAM, file.getName());
    }

    public MultipartFile(String name, InputStream is, long size, String fileName) {
        this(name, is, size, APPLICATION_OCTET_STREAM, fileName);
    }

    public MultipartFile(String name, byte[] is, String fileName) {
        this(name, new ByteArrayInputStream(is), is.length, APPLICATION_OCTET_STREAM, fileName);
    }

    public MultipartFile(String name, InputStream is, long size, String contentType, String fileName) {
        this.fileName = fileName;
        this.size = size;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.name = name;
        this.is = is;
        this.contentType = contentType != null ? contentType : APPLICATION_OCTET_STREAM;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public long getSize() {
        return this.size;
    }
}

