package com.digiwin.athena.apimgmt.infra.context;

import com.digiwin.athena.apimgmt.enums.LocaleEnum;
import com.digiwin.athena.apimgmt.infra.auth.ApiMgmtIdentity;
import jakarta.annotation.Nullable;

import java.util.Map;
import java.util.Optional;

/**
 * 服务上下文接口 - 抽象服务上下文功能
 * 提供用户信息、语言设定、请求参数等上下文功能
 */
public interface IApiMgmtServiceContext {

    /**
     * @return 获取token信息
     */
    @Nullable
    String getToken();

    /**
     *
     * @return 获取用户信息
     */
    Optional<ApiMgmtIdentity> getUserInfo();

    /**
     * @return 获取用户ID
     */
    @Nullable
    String getUserId();

    /**
     * @return 获取用户名称
     */
    @Nullable
    String getUserName();

    /**
     * @return 获取租户ID
     */
    @Nullable
    String getTenantId();

    /**
     * @return 获取teamID
     */
    @Nullable
    String getTeamId();

    /**
     *
     * @return 租户类型
     */
    @Nullable
    String getTeamType();

    /**
     * @return 获取语言
     * @see LocaleEnum#getType()
     */
    @Nullable
    String getLocale();

    /**
     * @return header routerKey
     */
    @Nullable
    String getRouterKey();

    /**
     * 获取请求头信息
     *
     * @return 请求头Map
     */
    Map<String, Object> getRequestHeader();

    /**
     * 获取响应头信息
     *
     * @return 响应头Map
     */
    Map<String, Object> getResponseHeader();
}