package com.digiwin.athena.apimgmt.infra.prop;

import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Data
public class ApiMgmtMdcProp {
    private Val review = new Val();
    private Val confirmed = new Val();

    private Integer batchNum;

    public static List<String> split(Val val) {
        return Optional.ofNullable(val)
                .map(Val::getUrl)
                .map(v -> StrUtil.splitTrim(v, ","))
                .orElse(Collections.emptyList());
    }

    public List<String> getConfirmedUrlList() {
        return split(confirmed);
    }

    public List<String> getReviewUrlList() {
        return split(review);
    }


    @Data
    public static class Val {
        private String url;
    }
}
