package com.digiwin.athena.apimgmt.infra.prop;

import com.digiwin.athena.apimgmt.util.Base64;
import com.digiwin.athena.apimgmt.util.Base64Util;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

@Data
@Slf4j
public class ApiMgmtDmcProp {
    private String url;
    private String user;
    private Boolean isPasswordHashed = false;
    private String password;
    private String bucket;
    private String directoryId;


    public String getHashedPassword() {
        if (isPasswordHashed) {
            return password;
        }

        return passwordHash(Base64Util.decodeString(password));
    }


    protected String passwordHash(String pPassword) {
        String tPasswordHash = null;
        try {
            byte[] hash;
            hash = MessageDigest.getInstance("SHA-256").digest(pPassword.getBytes(StandardCharsets.UTF_8));
            hash = MessageDigest.getInstance("SHA-256").digest(hash);
            tPasswordHash = Base64.encode(hash);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return tPasswordHash;
    }

}
