package com.digiwin.athena.apimgmt.infra.prop;

import lombok.Data;

@Data
public class ApiMgmtProp {
    private Val devPlatform = new Val();

    /**
     * 开启权限验证,通过类型添加区分pass区还是test区
     */
    private boolean envType = false;

    private String iamUrl;
    private String iamToken;
    private Integer iamSocketTimeout = 1500;

    private String integrationUserId;
    private String integrationPwd;

    private String translateCenterUrl;

    private String eaiUrl;

    private String exportPath = System.getProperty("user.dir") + "/apimgmt";
    private String templatePath = "template/";

    private String schemaName;
    private String selfInvokeUrl;

    private Schedule schedule = new Schedule();


    public String getSelfInvokeUrl() {
        if (selfInvokeUrl != null) {
            return selfInvokeUrl;
        }

        return getDevPlatform().getUrl();
    }


    @Data
    public static class Val {
        private String url;
    }

    @Data
    public static class Schedule {
        private String mdcFailSync;
    }

}

