package com.digiwin.athena.apimgmt.infra.http;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.beans.Transient;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Supplier;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HttpResponse {
    private int statusCode;
    private Map<String, String> header;
    private transient Supplier<String> bodyConverter;
    private transient InputStream is;


    public String getBody() {
        return bodyConverter.get();
    }

    @Transient
    public InputStream getInputStream() {
        return is;
    }

    @Override
    public String toString() {
        return "HttpResponse{" +
                "statusCode=" + statusCode +
                ", header=" + header +
                ", body=" + getBody() +
                '}';
    }
}
