/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.service.impl;

import com.digiwin.app.eai.pojo.EAIBaseParameter;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.appparameter.dao.IAppParamDao;
import com.digiwin.athena.appparameter.entity.AppParamEntity;
import com.digiwin.athena.appparameter.params.AppParamMergeParam;
import com.digiwin.athena.appparameter.params.AppParamQueryParam;
import com.digiwin.athena.appparameter.service.IAppParamService;
import com.digiwin.athena.appparameter.utils.EaiResultUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppParamServiceImpl
implements IAppParamService {
    private static final Log LOG = LogFactory.getLog(AppParamServiceImpl.class);
    @Resource
    @Qualifier(value="appParamDao")
    private IAppParamDao appParamDao;

    @Override
    public DWEAIResult getAppParams(Map<String, Object> header, EAIBaseParameter<AppParamQueryParam> messageBody) throws Exception {
        DWEAIResult result = null;
        List<AppParamEntity> appParamList = null;
        AppParamQueryParam param = (AppParamQueryParam)messageBody.getStdData().getParameter();
        try {
            appParamList = this.appParamDao.queryAppParams(param.getTenantId(), param.getEocId());
        }
        catch (Exception e) {
            result = EaiResultUtil.getFailureResult(e.getMessage());
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (Objects.isNull(result)) {
            List<Map<String, Object>> appParamItems = this.entityToMap(appParamList);
            result = EaiResultUtil.getSuccessResult(appParamItems);
        }
        return result;
    }

    @Override
    public DWEAIResult mergeAppParams(Map<String, Object> header, EAIBaseParameter<AppParamMergeParam> messageBody) throws Exception {
        DWEAIResult result = EaiResultUtil.getSuccessResult(Collections.emptyList());
        AppParamMergeParam param = (AppParamMergeParam)messageBody.getStdData().getParameter();
        List<AppParamEntity> appParamList = this.convertToEntity(param);
        try {
            this.appParamDao.saveAppParams(appParamList);
        }
        catch (Exception e) {
            result = EaiResultUtil.getFailureResult(e.getMessage());
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private List<Map<String, Object>> entityToMap(List<AppParamEntity> appParamList) {
        ArrayList<Map<String, Object>> entityList = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(appParamList)) {
            appParamList.forEach(appParam -> {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("param_id", appParam.getParamId());
                item.put("param_value", appParam.getParamValue());
                entityList.add(item);
            });
        }
        return entityList;
    }

    private List<AppParamEntity> convertToEntity(AppParamMergeParam param) {
        ArrayList<AppParamEntity> appParamList = new ArrayList<AppParamEntity>();
        param.getParamList().forEach(paramItem -> {
            AppParamEntity appParamEntity = new AppParamEntity();
            appParamEntity.setParamId(paramItem.getParamId());
            appParamEntity.setParamValue(paramItem.getParamValue());
            appParamEntity.setEocId(param.getEocId());
            appParamEntity.setTenantId(param.getTenantId());
            appParamEntity.setBuildTime(new Timestamp(System.currentTimeMillis()));
            appParamEntity.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            appParamList.add(appParamEntity);
        });
        return appParamList;
    }
}

