/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.config;

import com.digiwin.app.dao.DWDao;
import com.digiwin.athena.appparameter.condition.AppParamCondition;
import com.digiwin.athena.appparameter.dao.IAppParamDao;
import com.digiwin.athena.appparameter.dao.impl.AppParamDaoImpl;
import com.digiwin.athena.appparameter.exceptions.AppParameterException;
import com.digiwin.athena.appparameter.runner.AppParamRunner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
@ComponentScan(value={"com.digiwin.athena.appparameter"})
@ConditionalOnClass(value={DataSource.class})
@Conditional(value={AppParamCondition.class})
public class AppParamAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(AppParamAutoConfiguration.class);

    public AppParamAutoConfiguration() {
        LOGGER.info((Object)"Create 'AppParamAutoConfiguration' instance.");
    }

    @Bean
    @DependsOn(value={"dw-proxyDataSource"})
    @ConditionalOnMissingBean
    public AppParamRunner appParamRunner(Environment environment, @Qualifier(value="dw-dataSource") @Autowired(required=false) DataSource dataSource, @Qualifier(value="dw-multipleAppRoutingDataSource") @Autowired(required=false) AbstractRoutingDataSource routingDataSource) {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        if (AppParamCondition.isAppParamEnabled(environment)) {
            dataSources.add(dataSource);
        }
        if (!Objects.isNull(routingDataSource)) {
            Map<Object, DataSource> dataSourceMap = this.getResolvedDataSources(routingDataSource);
            dataSources.addAll(this.filterDataSource(dataSourceMap, environment));
        }
        return new AppParamRunner(dataSources);
    }

    @Bean(value={"appParamDao"})
    @DependsOn(value={"dw-dao"})
    @ConditionalOnMissingBean
    public IAppParamDao appParamDao(@Qualifier(value="dw-dao") DWDao dwDao) {
        return new AppParamDaoImpl(dwDao);
    }

    private List<DataSource> filterDataSource(Map<Object, DataSource> dataSources, Environment environment) {
        ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
        dataSources.forEach((dsName, dataSource) -> {
            String appId = (String)dsName;
            if (Boolean.parseBoolean(environment.getProperty(String.format("dap.merged.apps.%s.app.param.enabled", appId), Boolean.FALSE.toString()))) {
                dataSourceList.add((DataSource)dataSource);
            }
        });
        return dataSourceList;
    }

    private Map<Object, DataSource> getResolvedDataSources(AbstractRoutingDataSource routingDataSource) {
        try {
            Field resolvedDataSourcesField = AbstractRoutingDataSource.class.getDeclaredField("resolvedDataSources");
            resolvedDataSourcesField.setAccessible(Boolean.TRUE);
            return (Map)resolvedDataSourcesField.get(routingDataSource);
        }
        catch (Exception e) {
            throw new AppParameterException("Access field 'resolvedDataSources' of class 'AbstractRoutingDataSource' failed.", e);
        }
    }
}

