/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.dao.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.athena.appparameter.dao.IAppParamDao;
import com.digiwin.athena.appparameter.entity.AppParamEntity;
import com.digiwin.athena.appparameter.exceptions.AppParameterException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AppParamDaoImpl
implements IAppParamDao {
    private DWDao dwDao;

    public AppParamDaoImpl(DWDao dwDao) {
        this.dwDao = dwDao;
    }

    @Override
    public List<AppParamEntity> queryAppParams(String tenantId, String eocId) {
        ArrayList<AppParamEntity> appParamList = new ArrayList<AppParamEntity>();
        try (Connection connection = this.dwDao.getQueryRunner().getDataSource().getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT id, param_id, param_value, tenant_id, eoc_id, build_time, \n       update_time, create_user_id, update_user_id \nFROM app_parameter \nWHERE tenant_id = ? AND eoc_id = ? \nORDER BY update_time DESC");){
            statement.setString(1, tenantId);
            statement.setString(2, eocId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    AppParamEntity param = this.mapResultSetToEntity(resultSet);
                    appParamList.add(param);
                }
            }
        }
        catch (SQLException e) {
            throw new AppParameterException("Query app parameter list error", e);
        }
        return appParamList;
    }

    @Override
    public void saveAppParams(List<AppParamEntity> appParams) {
        try (Connection connection = this.dwDao.getQueryRunner().getDataSource().getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO app_parameter \n       (param_id, param_value, tenant_id, eoc_id, build_time, create_user_id, update_user_id, update_time) \nVALUES (?, ?, ?, ?, ?, ?, ?, ?) \nON DUPLICATE KEY UPDATE \n       param_value = VALUES(param_value),\n       update_user_id = VALUES(update_user_id),\n       update_time = VALUES(update_time)");){
            connection.setAutoCommit(Boolean.FALSE);
            try {
                for (AppParamEntity param : appParams) {
                    int index = 0;
                    statement.setString(++index, param.getParamId());
                    statement.setString(++index, param.getParamValue());
                    statement.setString(++index, param.getTenantId());
                    statement.setString(++index, param.getEocId());
                    statement.setTimestamp(++index, param.getBuildTime());
                    statement.setString(++index, param.getCreateUserId());
                    statement.setString(++index, param.getUpdateUserId());
                    statement.setTimestamp(++index, param.getUpdateTime());
                    statement.addBatch();
                }
                statement.executeBatch();
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            throw new AppParameterException("Batch save app params error", e);
        }
    }

    private AppParamEntity mapResultSetToEntity(ResultSet resultSet) throws SQLException {
        AppParamEntity param = new AppParamEntity();
        param.setId(resultSet.getLong("id"));
        param.setParamId(resultSet.getString("param_id"));
        param.setParamValue(resultSet.getString("param_value"));
        param.setTenantId(resultSet.getString("tenant_id"));
        param.setEocId(resultSet.getString("eoc_id"));
        param.setBuildTime(resultSet.getTimestamp("build_time"));
        param.setUpdateTime(resultSet.getTimestamp("update_time"));
        param.setCreateUserId(resultSet.getString("create_user_id"));
        param.setUpdateUserId(resultSet.getString("update_user_id"));
        return param;
    }
}

