/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.params;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class AppParamMergeParam
implements Serializable {
    @SerializedName(value="tenant_id")
    @NotNull
    private String tenantId;
    @SerializedName(value="eoc_id")
    @NotNull
    private String eocId;
    @SerializedName(value="param_list")
    @Valid
    private List<ParamBody> paramList;
    @SerializedName(value="update_time")
    private String updateTime;
    @SerializedName(value="update_user_id")
    private String updateUserId;

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getEocId() {
        return this.eocId;
    }

    public void setEocId(String eocId) {
        this.eocId = eocId;
    }

    public List<ParamBody> getParamList() {
        return this.paramList;
    }

    public void setParamList(List<ParamBody> paramList) {
        this.paramList = paramList;
    }

    public Timestamp getUpdateTime() {
        if (StringUtils.hasText((String)this.updateTime)) {
            return Timestamp.valueOf(LocalDateTime.parse(this.updateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        return null;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateUserId() {
        return this.updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public String toString() {
        return "AppParamMergeParam{tenantId='" + this.tenantId + '\'' + ", eocId='" + this.eocId + '\'' + ", paramList=" + this.paramList + ", updateTime=" + this.updateTime + ", updateUserId='" + this.updateUserId + '\'' + '}';
    }

    public static class ParamBody
    implements Serializable {
        @SerializedName(value="param_id")
        @NotNull
        private String paramId;
        @SerializedName(value="param_value")
        @NotNull
        private String paramValue;

        public String getParamId() {
            return this.paramId;
        }

        public void setParamId(String paramId) {
            this.paramId = paramId;
        }

        public String getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(String paramValue) {
            this.paramValue = paramValue;
        }

        public String toString() {
            return "ParamBody{paramId='" + this.paramId + '\'' + ", paramValue='" + this.paramValue + '\'' + '}';
        }
    }
}

