/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.service.impl;

import com.digiwin.app.eai.pojo.EAIBaseParameter;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.appparameter.dao.IAppParamDao;
import com.digiwin.athena.appparameter.entity.AppParamEntity;
import com.digiwin.athena.appparameter.exceptions.AppParameterException;
import com.digiwin.athena.appparameter.params.AppParamMergeParam;
import com.digiwin.athena.appparameter.params.AppParamQueryParam;
import com.digiwin.athena.appparameter.service.IAppParamService;
import com.digiwin.athena.appparameter.utils.EaiResultUtil;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AppParamServiceImpl
implements IAppParamService {
    private static final Log LOG = LogFactory.getLog(AppParamServiceImpl.class);

    @Override
    public DWEAIResult getAppParams(Map<String, Object> header, EAIBaseParameter<AppParamQueryParam> messageBody) throws Exception {
        DWEAIResult result = null;
        List<AppParamEntity> appParamList = null;
        AppParamQueryParam param = (AppParamQueryParam)messageBody.getStdData().getParameter();
        try {
            appParamList = this.getAppParamDao().queryAppParams(param.getTenantId(), param.getEocId());
        }
        catch (Exception e) {
            result = EaiResultUtil.getFailureResult(e.getMessage());
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (Objects.isNull(result)) {
            result = EaiResultUtil.getSuccessResult(this.convertToResult(appParamList));
        }
        return result;
    }

    @Override
    public DWEAIResult mergeAppParams(Map<String, Object> header, EAIBaseParameter<AppParamMergeParam> messageBody) throws Exception {
        DWEAIResult result = EaiResultUtil.getSuccessResult(Collections.emptyMap());
        AppParamMergeParam param = (AppParamMergeParam)messageBody.getStdData().getParameter();
        List<AppParamEntity> appParamList = this.convertToEntity(param);
        try {
            this.getAppParamDao().saveAppParams(appParamList);
        }
        catch (Exception e) {
            result = EaiResultUtil.getFailureResult(e.getMessage());
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> convertToResult(List<AppParamEntity> dataList) {
        List<Map<String, Object>> dataItems = this.entityToMap(dataList);
        AppParamEntity appParamItem = dataList.isEmpty() ? new AppParamEntity() : dataList.get(0);
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        resultData.put("param_list", dataItems);
        resultData.put("update_user_id", appParamItem.getUpdateUserId());
        resultData.put("update_time", appParamItem.getUpdateTime() != null ? appParamItem.getUpdateTime().toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
        return resultData;
    }

    private List<Map<String, Object>> entityToMap(List<AppParamEntity> appParamList) {
        ArrayList<Map<String, Object>> entityList = new ArrayList<Map<String, Object>>();
        if (!CollectionUtils.isEmpty(appParamList)) {
            appParamList.forEach(appParam -> {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("param_id", appParam.getParamId());
                item.put("param_value", appParam.getParamValue());
                entityList.add(item);
            });
        }
        return entityList;
    }

    private List<AppParamEntity> convertToEntity(AppParamMergeParam param) {
        String userId;
        ArrayList<AppParamEntity> appParamList = new ArrayList<AppParamEntity>();
        Timestamp triggerTime = param.getUpdateTime();
        if (Objects.isNull(triggerTime)) {
            triggerTime = new Timestamp(System.currentTimeMillis());
        }
        if (!StringUtils.hasText((String)(userId = param.getUpdateUserId())) && Objects.nonNull(DWServiceContext.getContext().getProfile())) {
            userId = (String)DWServiceContext.getContext().getProfile().get("userId");
        }
        String finalUserId = userId;
        Timestamp finalTriggerTime = triggerTime;
        param.getParamList().forEach(paramItem -> {
            AppParamEntity appParamEntity = new AppParamEntity();
            appParamEntity.setParamId(paramItem.getParamId());
            appParamEntity.setParamValue(paramItem.getParamValue());
            appParamEntity.setEocId(param.getEocId());
            appParamEntity.setTenantId(param.getTenantId());
            appParamEntity.setCreateUserId(finalUserId);
            appParamEntity.setUpdateUserId(finalUserId);
            appParamEntity.setBuildTime(finalTriggerTime);
            appParamEntity.setUpdateTime(finalTriggerTime);
            appParamList.add(appParamEntity);
        });
        return appParamList;
    }

    private IAppParamDao getAppParamDao() {
        if (!SpringContextUtils.containsBean((String)"appParamDao")) {
            throw new AppParameterException(String.format("Bean '%s' not instantiated, because the 'app.param.enabled' not enabled", "appParamDao"));
        }
        return (IAppParamDao)SpringContextUtils.getBean((String)"appParamDao");
    }
}

