/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.condition;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class AppParamCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment env = context.getEnvironment();
        Map<String, Object> properties = ((ConfigurableEnvironment)env).getPropertySources().stream().filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> (EnumerablePropertySource)ps).flatMap(ps -> Arrays.stream(ps.getPropertyNames())).filter(name -> name.startsWith("dap.merged.apps") && name.endsWith("app.param.enabled")).collect(Collectors.toMap(name -> name, name -> env.getProperty(name, Boolean.FALSE.toString())));
        boolean appParamEnabled = properties.values().stream().anyMatch(value -> Boolean.TRUE.toString().equals(value));
        boolean defaultEnabled = AppParamCondition.isAppParamEnabled(env);
        return defaultEnabled || appParamEnabled;
    }

    public static boolean isAppParamEnabled(Environment env) {
        return Boolean.parseBoolean(env.getProperty("app.param.enabled", Boolean.FALSE.toString()));
    }
}

