/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appparameter.runner;

import com.digiwin.athena.appparameter.constants.AppParamConstants;
import com.digiwin.athena.appparameter.utils.SqlCommand;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class AppParamRunner {
    private static final Log LOGGER = LogFactory.getLog(AppParamRunner.class);
    private final List<DataSource> dataSources;

    public AppParamRunner(List<DataSource> dataSources) {
        this.dataSources = dataSources;
        this.init();
    }

    private void init() {
        if (!CollectionUtils.isEmpty(this.dataSources)) {
            this.dataSources.forEach(dataSource -> {
                if (!SqlCommand.getInstance().isTableExists((DataSource)dataSource, "app_parameter")) {
                    SqlCommand.getInstance().execute((DataSource)dataSource, AppParamConstants.APP_PARAM_SQLS);
                }
            });
        }
        LOGGER.info((Object)"The bean of 'appParamRunner' initialized.");
    }
}

