package com.digiwin.athena.auth.metadata.domain;

import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class Authority {
    private String code;

    /**
     * 主体类型
     *
     * @see com.digiwin.athena.auth.metadata.enums.SubjectTypeEnum
     */
    private String subjectType;

    private String subjectCode;

    /**
     * 授权角色, 在将用户和角色关联的时候，默认赋上权限
     *
     * @see com.digiwin.athena.auth.metadata.enums.PermissionPolicyEnum
     */
    private String accreditRole;

    private String relatePolicy;

    private String resourceId;
}
