package com.digiwin.athena.auth.metadata.domain;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(of = {"effect", "accreditRole", "resourceType"})
public class AuthorityPolicy {
    private String code;

    private String effect;

    private List<String> action;

    /**
     * 授权角色, 在将用户和角色关联的时候，默认赋上权限
     *
     * @see com.digiwin.athena.auth.metadata.enums.PermissionPolicyEnum
     */
    private String accreditRole;

    private String resourceType;

    private String resourceId;

    private String authType;

    private List<ResourceCondition> conditions;

    public void addActions(Collection<String> actions) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        this.action.addAll(actions);
    }
}
