package com.digiwin.athena.auth.metadata.enums;

import com.digiwin.athena.auth.metadata.constants.AuthConstant;

public enum PermissionPolicyEnum {
    TENANT_SA("tenant:super", "租户-超管", "tenantSa.json", AuthConstant.ResourceType.TENANT),
    APP_MGR("application:mgr", "应用-管理员", "appMgr.json", AuthConstant.ResourceType.APPLICATION),
    APP_ACTOR("application:actor", "应用-协作者", "appActor.json", AuthConstant.ResourceType.APPLICATION),

    ASSIGN_MGR("assignment:mgr", "作业-管理员", "assignmentMgr.json", AuthConstant.ResourceType.ASSIGNMENT),
    ASSIGN_ACTOR("assignment:actor", "作业-协作者", "assignmentActor.json", AuthConstant.ResourceType.ASSIGNMENT),
    PUBLISH_MGR("publish:mgr", "发版-管理员", "publishMgr.json", AuthConstant.ResourceType.PUBLISH),
    PUBLISH_ACTOR("publish:actor", "发版-协作者", "publishActor.json", AuthConstant.ResourceType.PUBLISH),
    DATA_STD_MGR("dataStandard:mgr", "数据标准-管理员", "dataStandardMgr.json", AuthConstant.ResourceType.DATA_STANDARD),
    DATA_STD_ACTOR("dataStandard:actor", "数据标砖-协作者", "dataStandardActor.json", AuthConstant.ResourceType.DATA_STANDARD),
    RESULT_MGR("result:mgr", "开发成果-管理员", "resultMgr.json", AuthConstant.ResourceType.RESULT),
    RESULT_ACTOR("result:actor", "开发成果-协作者", "resultActor.json", AuthConstant.ResourceType.RESULT),
    INTEGRATION_MGR("integration:mgr", "集成中心-管理员", "integrationMgr.json", AuthConstant.ResourceType.INTEGRATION),
    INTEGRATION_ACTOR("integration:actor", "集成中心-协作者", "integrationActor.json", AuthConstant.ResourceType.INTEGRATION);

    private String role;

    private String name;

    private String templateFileName;

    private String resourceType;

    public String getRole() {
        return role;
    }

    public void setRole(String code) {
        this.role = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplateFileName() {
        return templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public String getResourceType() {
        return resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    PermissionPolicyEnum(String role, String name, String templateFileName, String resourceType) {
        this.role = role;
        this.name = name;
        this.templateFileName = templateFileName;
        this.resourceType = resourceType;
    }

    public static String getTemplateByRole(String role) {
        for (PermissionPolicyEnum value : PermissionPolicyEnum.values()) {
            if (value.getRole().equals(role)) {
                return value.getTemplateFileName();
            }
        }
        return null;
    }

    public static String getResourceTypeByRole(String role) {
        for (PermissionPolicyEnum value : PermissionPolicyEnum.values()) {
            if (value.getRole().equals(role)) {
                return value.getResourceType();
            }
        }
        return null;
    }
}
