package com.digiwin.athena.auth.metadata.domain;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.List;

@Data
@Accessors(chain = true)
public class RolePolicy {
    private String role;

    private List<String> allowActions;

    private List<String> denyActions;

    public void addAllowAction(List<String> action) {
        if (this.allowActions == null) {
            this.allowActions = new ArrayList<String>();
        }
        this.allowActions.addAll(action);
    }

    public void addDenyAction(List<String> action) {
        if (this.denyActions == null) {
            this.denyActions = new ArrayList<String>();
        }
        this.denyActions.addAll(action);
    }
}
