package com.digiwin.athena.auth.metadata.domain;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 资源授权表
 */
@Data
@Accessors(chain = true)
public class ResourceAuthorization {
    private String code;

    /**
     * 资源类型
     *
     * @see com.digiwin.athena.auth.metadata.constants.AuthConstant.ResourceType
     */
    private String resourceType;

    private String resourceId;

    /**
     * 授权角色, 在将用户和角色关联的时候，默认赋上权限
     *
     * @see com.digiwin.athena.auth.metadata.enums.PermissionPolicyEnum
     */
    private String accreditRole;

    /**
     * 授权对象类型
     */
    private String accreditObjectType;

    /**
     * 授权对象
     */
    private String accreditObject;

    /**
     * 状态
     *
     * @see com.digiwin.athena.auth.metadata.enums.ResourceStatusEnum
     */
    private String status;

    private String description;

}
